<?php $this->extend('layouts\master') ?>

<?php $this->section('banks') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">New Bank Offer</div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#bankModal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Bank Name</th>
                                            <th class="p-2" scope="col">Card Type</th>
                                            <th class="p-2" scope="col">Offer Rate</th>
                                            <th class="p-2" scope="col">From</th>
                                            <th class="p-2" scope="col">To</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                                
                                            ?>
                                            <tr id="<?php echo $s['BID']; ?>">     
                                                <td><?php echo $s['BankName']; ?></td>
                                                <td><?php echo $s['BCardType']; ?></td>
                                                <td><?php echo $s['BRate']; ?></td>
                                                <td><?php echo $s['BStartingDate']; ?></td>
                                                <td><?php echo $s['BEndingDate']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="bankedit" type="button" data-bs-toggle="modal" data-bs-target="#bankModal" data-id="<?php echo $s['BID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="bankdelete" type="button" data-id="<?php echo $s['BID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start bank data insert and update model -->
        <div class="modal fade" id="bankModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Bank Detail Form</h5>
                        <button type="button" id="closefrm" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add_banks" name="add_banks" action="<?= site_url('/submitBanks') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                <input type="hidden" class="form-control mb-3" name="BID" id="BID" placeholder="Enter Location Name" hidden  value="<?php echo set_value('BID');?>">
                                    <input type="text" class="form-control" value="<?php echo set_value('BankName');?>"  name="BankName" id="BankName" placeholder="Enter Bank Name">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'BankName') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">                                
                                <div class="mb-3 col">
                                    <select class="form-control" name="BCardType" id="BCardType">
                                    <option value="">Please Select the val</option> 
                                        <option  value="Credit Card"  <?php echo  set_select('BCardType', 'Credit Card'); ?> >Credit Card</option>
                                        <option value="Debit Card" <?php echo  set_select('BCardType', 'Debit Card'); ?> >Debit Card</option>
                                        <option  value="Other"  <?php echo  set_select('BCardType', 'Other'); ?> >Other</option>
                                    </select>
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'BCardType') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control"  value="<?php echo set_value('BRate');?>" name="BRate" id="BRate" placeholder="Enter Bank Discount Rate">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'BRate') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="mb-3 col">
                                    <input type="date" class="form-control"  value="<?php echo set_value('BStartingDate');?>" name="BStartingDate" id="BStartingDate" placeholder="Enter Offer Starting Date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'BStartingDate') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <input type="date" class="form-control" value="<?php echo set_value('BEndingDate');?>"  name="BEndingDate" id="BEndingDate" placeholder="Enter Offer Ending Date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'BEndingDate') : '' ?></h6>
                                </div>
                            </div>                            
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- end  bank data insert and update  model -->
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
        function openBankModal(){
            var bank_modal = $("#bankModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                bank_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openBankModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            EmpTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                EmpTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    EmpTable.rows().select();        
                } else {
                    EmpTable.rows().deselect(); 
                }
            });

            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                

        //update bank
        $('body').on('click', '#bankedit', function () {
            var bank_id = $(this).attr('data-id');
            $.ajax({
                url: 'banks/edit/'+bank_id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#bankModal').modal('show');
                    $('#add_banks #BID').val(res.data.BID); 
                    $('#add_banks #BankName').val(res.data.BankName); 
                    $('#add_banks #BCardType').val(res.data.BCardType);
                    $('#add_banks #BRate').val(res.data.BRate);
                    $('#add_banks #BStartingDate').val(res.data.BStartingDate);
                    $('#add_banks #BEndingDate ').val(res.data.BEndingDate);
                },
                    error: function (data) {
                }
            });
        });

         //delete bank
         $('body').on('click', '#bankdelete', function () {
                var bankid = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ bankid).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'banks/delete/'+bankid,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ bankid).remove();
                            }
                        }
                    });
                }
            });          
        });

        //reset form
        $('#bankModal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
            });

       
    </script>
<?php $this->endSection() ?>