<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Evolve POS System</title>
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
            <link rel="stylesheet" href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
            <link rel="stylesheet" href="scss/main.css">
        </head>

        <body class="bg-third">
            <!--- Top-Menu --->
            <div class="clearfix bd-highlight top-menu bg-secondary p-1">
                <div class="float-start">
                    <a href="https://evolve-sl.com/"><img src="./assets/images/logo/logo-removebg-preview.png" alt="main_log"></a>
                </div>
                <?php if($breadcrumbs == 'true'){?>
                    <div class="float-start ms-2">
                        <div class=" ms-auto me-auto">
                            <div class="subtitle-line  ms-auto me-auto ml-1">
                                <div class="d-flex bd-highlight ">
                                    <div class="flex-fill bd-highlight text-primary mt-1">
                                        <small>Index</small> / List of <?php echo $title; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }else{}?>
                <div class="float-end">
                    <div class="d-flex flex-row bd-highlight m-1 right-side">
                        <div class="p-1 gap-3 bd-highlight serach mx-2">
                            <label id="pos_machine_id" name="pos_machine_id">POS ID:
                                <?php 
                                    $localIP = getHostByName(getHostName()); 
                                    session()->set('pos_machine_id', $localIP);
                                    echo $localIP;
                                ?>
                            </label>
                        </div>
                        <div class="p-1 gap-3 bd-highlight serach mx-2">
                            <a href="#" class=""><img src="./assets/images/icons/search.svg" alt="serach"></a>
                        </div>
                        <div class="p-1 bd-highlight notification position-relative mx-2">
                            <a href="#" class="">
                                <img src="./assets/images/icons/notification-bing.svg" alt="notification">
                                <span class="position-absolute top-0 start-0 badge rounded-circle bg-primary">4</span>
                            </a>
                        </div>
                        <div class="p-1 bd-highlight user position-relative">
                            <a class="top-50 start-50" href="#">
                              
                                <div class="rounded-circle bg-primary active-dot"></div>
                               
                              
                            </a>
                        </div>
                        <div class="p-1 bd-highlight user position-relative">
                            <a class="top-50 start-50" href="#" style="text-decoration:none;">
                            <?= $userinfo->UserName; ?>
                            </a>
                        </div>
                        <div class="p-1 bd-highlight user position-relative">
                            <a class="top-50 start-50" href="/logout" style="text-decoration:none;">logout</a>
                        </div>
                    </div>
                </div>
            </div>
            <!--- Content --->
            <section class=" bg-secondary m-10 full-height bottom-round">
                <!--- Nav-menu --->
                <div class="container-fluid pt-3 nav-manu">
                    <div class="row menu-list">
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'index'){echo 'active';}?>">
                            <a href="/index" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/home.svg" alt="home" class="white-img mt-1">
                                <div class="menu-item-name">Home</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'customer'){echo 'active';}?>">
                            <a href="/customer" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/users.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Customers</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'items'){echo 'active';}?>">
                            <a href="/items" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/list.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Items</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'reports'){echo 'active';}?>">
                            <a href="/reports" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/file-text.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Reports</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'suppliers'){echo 'active';}?>">
                            <a href="/suppliers" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/truck.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Suppliers</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'receivings'){echo 'active';}?>">
                            <a href="/receivings" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/check-square.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Receivings</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'sales'){echo 'active';}?>">
                            <a href="/sales" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/shopping-cart.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Sale</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'employees'){echo 'active';}?>">
                            <a href="/employees" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/user-check.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Employees</div>
                            </a>
                        </div>
                        <div class="menu-item col text-center btn rounded linear-bg mx-1 ms-1 align-self-center p-2 text-secondary <?php if($link == 'config'){echo 'active';}?>">
                            <a href="/config" class="text-secondary text-decoration-none">
                                <img src="./assets/images/icons/box.svg" alt="Customers" class="white-img mt-1">
                                <div class="menu-item-name">Store Config</div>
                            </a>
                        </div>
                    </div>
                </div>
                <!--- Nav-menu End--->
                
                <?php $this->renderSection($link) ?>

            <script src="/node_modules/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
            <!-- <script src="http://code.jquery.com/jquery-1.10.0.min.js"></script> -->

            <!-- <script src="https://cdn.datatables.net/v/dt/dt-1.13.4/datatables.min.js"></script> -->
            
            <!-- <script>
                $(document).ready(function() {
                    $('#employees').DataTable( {
                        dom: 'Bfrtip',
                        buttons: [
                            { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                        ],                        
                        info: false
                    } );
                });
                $.extend( DataTable.ext.classes, {
                    "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
	                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
	                //"sFilter": "dnone",
                });

                //Check All
                function checkAll(o) {
                    var boxes = document.getElementsByClassName("select-checkbox");
                    for (var x = 0; x < boxes.length; x++) {
                        var obj = boxes[x];
                        if (obj.type == "checkbox") {
                        if (obj.name != "check")
                            obj.checked = o.checked;
                        }
                    }
                } 
            </script> -->
        </body>
    </html>