<?php $this->extend('layouts\master') ?>

<?php $this->section('suppliers') ?>

        <!---List of supplier --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-trash3-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#supplierModal"><i class="bi bi-plus-lg fw-bold"></i> New Supplier </button>
                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Company Name</th>
                                            <th class="p-2" scope="col">Sup Name</th>
                                            <th class="p-2" scope="col">Address</th>
                                            <th class="p-2" scope="col">E-mail</th>
                                            <th class="p-2" scope="col">Phone Number</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">
                                        <?php 
                                            if($sources):
                                            foreach($sources as $source): 
                                            foreach($source as $s): 
                                        ?>
                                            <tr id="<?php echo $s['SupplierID']; ?>">
                                                 <td><?php echo $s['SupplierCompanyName']; ?></td>
                                                 <td><?php echo $s['SupplierName']; ?></td>
                                                 <td><?php echo $s['SupplierAddressLine1']; ?></td>
                                                 <td><?php echo $s['SupplierEmail']; ?></td>
                                                 <td><?php echo $s['SupplierContactNo']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="suppedit" type="button" data-bs-toggle="modal" 
                                                    data-bs-target="#supplierModal" data-id="<?php echo $s['SupplierID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="suppdelete" type="button" data-id="<?php echo $s['SupplierID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                            endforeach;
                                            endforeach;
                                            endif;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Start Insert and Update Suppliers --->
            <div class="modal fade with-img-upload" id="supplierModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header linear-bg">
                            <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> Supplier Detail Form</h5>
                            <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <form action="<?= site_url('/supplierSave') ?>" id="add_supp"  method="post" accept-charset="utf-8"  enctype="multipart/form-data">
                                <div class="row">
                                    <div class="mb-3 wrapper col">
                                        <div class="box">
                                            <div class="js--image-preview">
                                            <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                            </div>
                                            <div class="upload-options">
                                                <label>
                                                    <input type="file" class="image_upload" accept="image/*" name="SuppImg" id="SuppImg">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                    <input type="hidden" class="form-control mb-3" name="SupplierID" id="SupplierID" hidden  value="<?php echo set_value('SupplierID');?>">
                                        <input type="text" class="form-control" name="SupplierCompanyName" id="SupplierCompanyName" value="<?php echo set_value('SupplierCompanyName');?>"  placeholder="Enter Company Name">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCompanyName') : '' ?></h6>
                                    </div>
                                
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierBRNo" id="SupplierBRNo" value="<?php echo set_value('SupplierBRNo');?>" placeholder="Enter Company BR No">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBRNo') : '' ?></h6>
                                    </div>
                                    
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierName" value="<?php echo set_value('SupplierName');?>" id="SupplierName" placeholder="Enter Supplier Name">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierName') : '' ?></h6>
                                    </div>
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierNIC" value="<?php echo set_value('SupplierNIC');?>"  id="SupplierNIC" placeholder="Enter Supplier NIC">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierNIC') : '' ?></h6>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierAddressLine1" value="<?php echo set_value('SupplierAddressLine1');?>"   id="SupplierAddressLine1" placeholder="Enter Address Line 1">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierAddressLine2" value="<?php echo set_value('SupplierAddressLine2');?>"  id="SupplierAddressLine2" placeholder="Enter Address Line 2">
                                 </div>
                               </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierCity" value="<?php echo set_value('SupplierCity');?>" id="SupplierCity" placeholder="Enter the City">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCity') : '' ?></h6>
                                    </div>
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierProvince" value="<?php echo set_value('SupplierProvince');?>" id="SupplierProvince" placeholder="Enter the Province">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierProvince') : '' ?></h6>
                                    </div>
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierCountry"  value="<?php echo set_value('SupplierCountry');?>" id="SupplierCountry" placeholder="Enter the Country">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierCountry') : '' ?></h6>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <input type="text" class="form-control" name="SupplierContactNo" value="<?php echo set_value('SupplierContactNo');?>" id="SupplierContactNo" placeholder="Enter the Contact No">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierContactNo') : '' ?></h6>
                                    </div>
                                    <div class="mb-3 col">
                                        <input type="email" class="form-control" name="SupplierEmail"value="<?php echo set_value('SupplierEmail');?>"  id="SupplierEmail" placeholder="Enter the Email">
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierEmail') : '' ?></h6>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                        <textarea class="form-control" name="SupplierDescription" value="<?php echo set_value('SupplierDescription');?>" id="SupplierDescription" placeholder="Enter Suppliers Description"></textarea>
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierDescription') : '' ?></h6>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col">
                                    <input type="text" class="form-control" name="SupplierBankName" value="<?php echo set_value('SupplierBankName');?>"  id="SupplierBankName" placeholder="Enter Supplier's Bank">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBankName') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" name="SupplierBankACNo" value="<?php echo set_value('SupplierBankACNo');?>"  id="SupplierBankACNo" placeholder="Enter Supplier's Bank No">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'SupplierBankACNo') : '' ?></h6>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                           </div>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
       
        <!--- end Insert and Update Suppliers  --->
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
         function openSupplierModal(){
            var sup_modal = $("#supplierModal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                sup_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openSupplierModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            SuppTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                SuppTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    SuppTable.rows().select();        
                } else {
                    SuppTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
    </script>
    <script>
        function initImageUpload(box) {
            let uploadField = box.querySelector('.image_upload');
            uploadField.addEventListener('change', getFile);
            function getFile(e) {
                let file = e.currentTarget.files[0];
                checkType(file);
            }
            function previewImage(file) {
                let thumb = box.querySelector('.js--image-preview'),
                    reader = new FileReader();
                reader.onload = function () {
                    thumb.style.backgroundImage = 'url(' + reader.result + ')';
                }
                reader.readAsDataURL(file);
                thumb.className += ' js--no-default';
            }
            function checkType(file) {
                let imageType = /image.*/;
                if (!file.type.match(imageType)) {
                    throw 'Datei ist kein Bild';
                } else if (!file) {
                    throw 'Kein Bild gewählt';
                } else {
                    previewImage(file);
                }
            }
        }
        // initialize box-scope
        var boxes = document.querySelectorAll('.box');
        for (let i = 0; i < boxes.length; i++) {
            let box = boxes[i];
            initDropEffect(box);
            initImageUpload(box);
        }
        /// drop-effect
        function initDropEffect(box) {
            let area, drop, areaWidth, areaHeight, maxDistance, dropWidth, dropHeight, x, y;
            // get clickable area for drop effect
            area = box.querySelector('.js--image-preview');
            area.addEventListener('click', fireRipple);
            function fireRipple(e) {
                area = e.currentTarget
                // create drop
                if (!drop) {
                    drop = document.createElement('span');
                    drop.className = 'drop';
                    this.appendChild(drop);
                }
                // reset animate class
                drop.className = 'drop';
                // calculate dimensions of area (longest side)
                areaWidth = getComputedStyle(this, null).getPropertyValue("width");
                areaHeight = getComputedStyle(this, null).getPropertyValue("height");
                maxDistance = Math.max(parseInt(areaWidth, 10), parseInt(areaHeight, 10));
                // set drop dimensions to fill area
                drop.style.width = maxDistance + 'px';
                drop.style.height = maxDistance + 'px';
                // calculate dimensions of drop
                dropWidth = getComputedStyle(this, null).getPropertyValue("width");
                dropHeight = getComputedStyle(this, null).getPropertyValue("height");
                // calculate relative coordinates of click
                // logic: click coordinates relative to page - parent's position relative to page - half of self height/width to make it controllable from the center
                x = e.pageX - this.offsetLeft - (parseInt(dropWidth, 10) / 2);
                y = e.pageY - this.offsetTop - (parseInt(dropHeight, 10) / 2) - 30;
                // position drop and animate
                drop.style.top = y + 'px';
                drop.style.left = x + 'px';
                drop.className += ' animate';
                e.stopPropagation();
            }
        }
        // update employe
        $('body').on('click', '#suppedit', function () { 
            var SupID = $(this).attr('data-id');
            $.ajax({
                url: 'supplier/edit/'+SupID,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#supplierModal').modal('show');
                    console.log(res.data)
                    $('#add_supp #SupplierCompanyName').val(res.data.SupplierCompanyName); 
                    $('#add_supp #SupplierBRNo').val(res.data.SupplierBRNo);
                    $('#add_supp #SupplierName').val(res.data.SupplierName); 
                    $('#add_supp #SupplierNIC').val(res.data.SupplierNIC);
                    $('#add_supp #SupplierAddressLine1').val(res.data.SupplierAddressLine1);
                    $('#add_supp #SupplierAddressLine2').val(res.data.SupplierAddresLine2);
                    $('#add_supp #SupplierCity   ').val(res.data.SupplierCity);
                    $('#add_supp #SupplierProvince').val(res.data.SupplierProvince);
                    $('#add_supp #SupplierCountry').val(res.data.SupplierCountry);
                    $('#add_supp #SupplierContactNo').val(res.data.SupplierContactNo);
                    $('#add_supp #SupplierEmail').val(res.data.SupplierEmail);
                    $('#add_supp #SupplierDescription').val(res.data.SupplierDescription);
                    $('#add_supp #SupplierBankName').val(res.data.SupplierBankName);
                    $('#add_supp #SupplierBankACNo   ').val(res.data.SupplierBankACNo);
                    $('#add_supp #SupplierID   ').val(res.data.SupplierID);
                    $('#add_supp #design  ').attr('src','/uploads/supImg/'+ res.data.SupplierImg);
                },
                    error: function (data) {
                        console.log(data);
                }
            });
        });
 //delete supplier
        $('body').on('click', '#suppdelete', function () {
                var SupID = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ SupID).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'supplier/delete/'+SupID,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ SupID).remove();
                            }
                        }
                    });
                }
            });          
        });
          //reset form
          $('#supplierModal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
            });
     
    </script>

<?php $this->endSection() ?>