<?php

namespace App\Models;

use CodeIgniter\Model;

class CommonModel extends Model
{
    function checkForeignKeyConstraints($table_name,$foreign_key_column,$id,$delete_flag,$delete_status){
        $data = $this->db->table($table_name)->where($delete_flag, $delete_status)->where([$foreign_key_column => $id])->get()->getRow();
        if($data){
            $has_relations = true;
        }
        else{
            $has_relations = false;
        }
        return  $has_relations;
    }
    function getSpecificColumnValueByGivenColumnName($table_name,$given_column_name,$select_column_name,$given_column_value,$delete_flag,$delete_status){
        $data = $this->db->table($table_name)->select($select_column_name)->where($delete_flag, $delete_status)->where([$given_column_name => $given_column_value])->get()->getRow();
        return $data;
    }
    function getLastInsertedID($table_name,$id_column_name,$delete_flag,$delete_status){
        $data = $this->db->table($table_name)->where($delete_flag, $delete_status)->orderBy($id_column_name, 'DESC')->get()->getRow();
        return $data;
    }
}