<?php

    namespace App\Models;

    use CodeIgniter\Model;

    class SaleItemsModel extends Model{

        protected $table      = 'sales';
        protected $primaryKey = 'id';

        protected $useAutoIncrement = true;

        protected $returnType     = 'array';
        protected $useSoftDeletes = false;

        protected $allowedFields = ['sale_id', 'item_id', 'batch_no', 'price', 'discount', 'qty', 'created_at','updated_at','deleted_at','delete_flag'];
        
        // Dates
        protected $useTimestamps = false;
        protected $dateFormat    = 'datetime';
        protected $createdField  = 'created_at';
        protected $updatedField  = 'updated_at';
        protected $deletedField  = 'deleted_at';

        // Validation
        protected $validationRules      = [];
        protected $validationMessages   = [];
        protected $skipValidation       = false;
        protected $cleanValidationRules = true;

        // Callbacks
        protected $allowCallbacks = true;
        protected $beforeInsert   = [];
        protected $afterInsert    = [];
        protected $beforeUpdate   = [];
        protected $afterUpdate    = [];
        protected $beforeFind     = [];
        protected $afterFind      = [];
        protected $beforeDelete   = [];
        protected $afterDelete    = [];

        // insert data
        function insertData($data)
        {
            return $this->db->table('sale_items')->insert($data);
        }
        //get specific sale data
        function getSpecificSaleData($sale_id){
            return $this->db->table('sale_items')->select('sale_items.*,item.ItemName')->where(["sale_id" => $sale_id])->join('item', 'item.ItemID = sale_items.item_id')->get()->getResultArray();
        }
    }

?>