<?php

namespace App\Models;

use CodeIgniter\Model;

class TempReceivingDetailModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'temp_receivingdetails';
    protected $primaryKey       = 'RDID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['CartID', 'RID', 'ItemID', 'RDIsSerialized', 'RDLine', 'RDQty', 'RDUnit', 'RDCostPrice', 'RDSellingPrice', 'RDMFD', 'RDEXP', 'RDiscount', 'RAmount', 'RDCreatedAt', 'RDUpdatedAt', 'RDDeletedAt', 'RDStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RDCreatedAt';
    protected $updatedField  = 'RDUpdatedAt';
    protected $deletedField  = 'RDDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function saveData($finalTabledata)
    {
        $db = db_connect();
        $builder = $db->table($this->table);

        $builder->insert($finalTabledata);

        return $db->insertID();
    }

    // get single Rec data
    function getSingleRecDetailData($id)
    {
        return $this->db
            ->table('temp_receivingdetails')
            ->where("temp_receivingdetails.CartID", $id)
                //->join('temp_itemserialized', 'temp_itemserialized.CartID = temp_receivingdetails.CartID', 'left')
                ->join('item', 'item.ItemID = temp_receivingdetails.ItemID', 'item.ItemID = itemunits.ItemID')
                ->join('units', 'units.UnitID = item.itemUnit')
            ->get()
            ->getResult();
    }

    // update temp receiving record
    function updateTempRecDetails($id,$data)
    {
        return $this->db
            ->table('temp_receivingdetails')
            ->where(["CartID" => $id])
            ->set($data)
            ->update();
    }
    
    // insert receiving temp serial data to db without ID return
    function insertRDData($data)
    {   
        return $this->db
            ->table('temp_receivingdetails')
            ->insert($data);
    }

    // delete previous data
    public function deletePreviousRecord($id)
    {
        return $this->db->table('temp_receivingdetails')->where('CartID', $id)->delete();
    }
}
