<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\UnitsModel;
use App\Models\ConversionFactorModel;
use App\Controllers\BaseController;
use App\Models\CommonModel;

class UnitandMeaturesController extends BaseController
{
    private $UserModel = null;
    private $UnitsModel = null;
    private $ConversionFactorModel = null;
    private $now = null;

    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->UnitsModel = new UnitsModel();
        $this->ConversionFactorModel = new ConversionFactorModel();
        $this->common = new CommonModel(); 
        $this->now = date("Y-m-d H:i:s");
        $this->db = \Config\Database::connect();
        helper(['url','form','app']);
    }


    // ================================================== Units =======================================================//
    //create & update units
    public function addupUnits()
    {
        $user_info = getUserInfo();
        $validation = $this->validate([
            'UnitName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter Unit Name',                  
                ],
            ],
            'UnitAbbre' => [
                'rules'=>[
                    'rules' => 'required',                    
                    'is_unique[units.UnitAbbreviation,UnitID,{UnitID}]',
                ],
                'errors'=>[
                    'required'=>'Please Enter Unit Abbreviation', 
                    'is_unique'=>'This Unit already exists!',                   
                ],
            ],
            'base_unit_id' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Select Base Unit',                  
                ],
            ],
        ]);
        if($validation){
            $session = session();
            $unitID = $this->request->getVar('UnitID');
            if($unitID == '')
            {
                $data = [
                    'UnitName' => $this->request->getVar('UnitName'),
                    'UnitAbbreviation'  => $this->request->getVar('UnitAbbre'),
                    'base_unit_id'  => $this->request->getVar('base_unit_id'),
                    'is_base_unit'  => $this->request->getVar('is_base_unit'),
                    'UnitCreatedAt' => $this->now,
                    'UnitCreatedBy' => $user_info->UserID,
                    'delete_flag' => '0',
                ];
                      //set trans status
                    $transaction_status = false;
                    //---begin transaction---
                    $this->db->transBegin();

                $this->UnitsModel->insertUnits($data);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                       // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('icon', 'warning');
                    $session->setFlashdata('message', 'Something Went wrong.');  
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                   // Set the success flash message
                    $session->setFlashdata('title', 'Saved');
                    $session->setFlashdata('icon', 'success');
                    $session->setFlashdata('message', 'Unit  details saved successfully.'); 
                }  
                //get last inserted unit id
                $last_inserted_unit_id = ($this->common->getLastInsertedID('units','UnitID','delete_flag',0))->UnitID;
                //check if base unit
                $is_base_unit = ($this->common->getSpecificColumnValueByGivenColumnName('units','UnitID','is_base_unit',$last_inserted_unit_id,'delete_flag',0))->is_base_unit;
                //update base unit id
                if($is_base_unit == 1){
                    $data = [
                        'base_unit_id'  => $last_inserted_unit_id,
                        'UnitUpdatedAt' => $this->now,
                        'UnitUpdatedBy' => $user_info->UserID,
                    ];
                    $this->UnitsModel->updateUnits($last_inserted_unit_id, $data);
                }
            }
            else
            {    
                $data = [
                    'UnitName' => $this->request->getVar('UnitName'),
                    'UnitAbbreviation'  => $this->request->getVar('UnitAbbre'),
                    'base_unit_id'  => $this->request->getVar('base_unit_id'),
                    'is_base_unit'  => $this->request->getVar('is_base_unit'),
                    'UnitUpdatedAt' => $this->now,
                    'UnitUpdatedBy' => $user_info->UserID,
                ];
                $this->UnitsModel->updateUnits($unitID, $data);
                //check if base unit
                $is_base_unit = ($this->common->getSpecificColumnValueByGivenColumnName('units','UnitID','is_base_unit',$unitID,'delete_flag',0))->is_base_unit;
                //update base unit id
                if($is_base_unit == 1){
                    $data = [
                        'base_unit_id'  => $unitID,
                        'UnitUpdatedAt' => $this->now,
                        'UnitUpdatedBy' => $user_info->UserID,
                    ];
                    $this->UnitsModel->updateUnits($unitID, $data);
                }
                // Set the success flash message
                $session->setFlashdata('title', 'Updated');
                $session->setFlashdata('message', 'Unit updated successfully.');
            }
            return $this->response->redirect(site_url('/unitandmeatures'));
        }
        else{
            $user_info = getUserInfo(); 
            $allunits = $this->UnitsModel->getIndexData();
            $active_units = $this->UnitsModel->getActiveUnitsData();
            $allCFs = $this->ConversionFactorModel->getAllCFsData();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Unit & Meatures',
                'link' => 'unitandmeatures',
                'userinfo' => $user_info,
                'allunits' => $allunits,
                'active_units' => $active_units,
                'allCFs' => $allCFs,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                    );
            return view('/unitandmeatures', $data);
            }
    }   
    public function index()
    {        
        $user_info = getUserInfo(); 
        $allunits = $this->UnitsModel->getIndexData();
        $active_units = $this->UnitsModel->getActiveUnitsData();
        $allCFs = $this->ConversionFactorModel->getAllCFsData();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Unit & Meatures',
            'link' => 'unitandmeatures',
            'userinfo' => $user_info,
            'allunits' => $allunits,
            'active_units' => $active_units,
            'allCFs' => $allCFs,
            'has_errors' =>$has_errors,
        );
        return view('unitandmeatures', $data);
    }
    //get single unit
    public function singleUnits($id = null)
    {
        $data = $this->UnitsModel->getSingleUnitData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete units
    public function deleteUnit($id = null)
    {
        $user_info = getUserInfo();
        $has_item_info = $this->common->checkForeignKeyConstraints("item","ItemUnit",$id,"delete_flag",0);
        $has_stocks_info = $this->common->checkForeignKeyConstraints("stocks","ItemID",$id,"StockStatus",1);
        $has_conversionfactor_fromUnit_info = $this->common->checkForeignKeyConstraints("conversionfactor","FromUnitiD",$id,"delete_flag",0);
        $has_conversionfactor_toUnit_info = $this->common->checkForeignKeyConstraints("conversionfactor","ToUnitID",$id,"delete_flag",0);
         //define message
         $msg_prefix = 'This unit  has ';
         $msg_conversionfactor_fromUnit_info = 'conversion factor information';
         $msg_conversionfactor_toUnit_info = 'conversion factor information';
         $msg_item_info = ' item information ';
         $msg = '';
                if($has_conversionfactor_fromUnit_info  ){
                    $msg = $msg_prefix.$msg_conversionfactor_fromUnit_info;
                }

                if($msg_conversionfactor_toUnit_info  ){
                    $msg = $msg_prefix.$msg_conversionfactor_fromUnit_info;
                }
        
                if($has_item_info){
                    $msg = $msg_prefix.$msg_item_info;
                }
         
        $data = [
            'UnitDeletedAt' => $this->now,
            'UnitDeletedBy' => $user_info->UserID,
            'delete_flag' => '1',
        ];
        if($has_item_info || $has_stocks_info || $has_conversionfactor_fromUnit_info||$has_conversionfactor_toUnit_info ){
            //    if($has_price_rule_info ){
                return $this->response->setJSON([
                    'error' => true,
                    'message' =>$msg
                ]);
            }
            else{
                $this->UnitsModel->deleteUnits($id, $data);
                return $this->response->setJSON([
                    'error' => false,
                    'message' => 'Successfully deleted!'
                ]);
            }

        // $this->UnitsModel->deleteUnits($id, $data);
        // return $this->response->setJSON([
        //     'error' => false,
        //     'message' => 'Successfully deleted!'
        // ]);
    }
    

      // unit disable
      public function disableunit($id = null)
      {
          $data = [
              'current_status' => '2'
          ];    
          
          if($this->UnitsModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
      // unit enable
      public function enableunit($id = null)
      {
          $data = [
              'current_status' => '1'
          ];
          if($this->UnitsModel->statusupdate($id, $data)):                
              echo json_encode(array('status'=>true));
          endif;
      }
    // ================================================== Units - End =======================================================//


    

}
