<?php

namespace App\Controllers;
use App\Models\UserPermissionModel;
use App\Models\UserRoleModel;
use App\Models\UserModel;
use App\Models\FunctionalityModel;
use App\Models\UserPermissionDetailModel;

use App\Controllers\BaseController;
// $validation = \Config\Services::validation();
class UserPermissionsController extends BaseController
{
    public function __construct()
    {
        helper(['url','form','app']);
        $this->UserPermissionModel = new UserPermissionModel();
        $this->URmodel = new UserRoleModel();
        $this->Umodel = new UserModel();
        $this->rulmodel = new FunctionalityModel();
        $this->UserPermissionDetailModel= new UserPermissionDetailModel();
        $this->db = \Config\Database::connect();
        $validation =  \Config\Services::validation();
    }
    // insert data
    public function insert()
    {
        $session = session();
        $validation = $this->validate([
            'FID' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'FID is required',
                ],
            ],

            'roleoruser' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'please select value',
                ],
            ],
        ]);

        if($validation){   
            if(($this->request->getVar('UserID'))){
                $data = [
                   'UserID'=>$this->request->getVar('UserID'),
                   'RBCreatedAt' => date('Y-m-d H:i:s'),
                   'delete_flag' => '0', 
                ];
            }
            else if($this->request->getVar('RoleID')){
                $data = [
                    'RoleID'=>$this->request->getVar('RoleID'),
                    'RBCreatedAt' => date('Y-m-d H:i:s'),
                    'delete_flag' => '0', 
                ];
            }
            $array = $_POST['FID']; //get all FID values to array
            $fid_array = array(); //initialize fid array
            $fnam_array = array(); //initialize fnam array
            foreach ($array as $item) {
                $fid_array[] =  (explode('/', $item))[0]; //split string using '/' and filter fid values
                $fnam_array[] =  (explode('/', $item))[1];
            }
            $data['FID']=implode(',', $fid_array );     //store fid values as comma seperated 
            $data['Fnames']=implode(',', $fnam_array );  //store fname values as comma seperated 

                //set trans status
            $transaction_status = false;
            //---begin transaction---
            $this->db->transBegin();
            // $this->UserPermissionModel ->insertuPermissionData($data);
           if( $this->UserPermissionModel ->insertuPermissionData($data)){
            $last_id =  $this->UserPermissionModel->insertID();     
           }
            $functionalities = $this->request->getVar('FID');
            if($functionalities):
                if($last_id):
                    $functionalityData = [];
                    foreach($functionalities as $functionality):
                        $functionalityData = [
                            'ruleBID' =>  $last_id,
                            'functionalityID' => $functionality,
                            'UserPermissionDetailStatus' => '1'
                        ];
                        $this->UserPermissionDetailModel->insertData($functionalityData);
                    endforeach;
                endif;
            endif;
            if ($this->db->transStatus() === FALSE){
                //---rollback transaction
                $this->db->transRollback();
                $transaction_status = false;
                   // Set the success flash message
                $session->setFlashdata('title', 'Error');
                $session->setFlashdata('icon', 'warning');
                $session->setFlashdata('message', 'Something Went wrong.');  
            }
            else{
                //---commit transaction
                $this->db->transCommit();
                $transaction_status = true;
               // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('icon', 'success');
                $session->setFlashdata('message', 'User Permission  details saved successfully.'); 
            }           
            return $this->response->redirect(site_url('/userpermissions'));
        }
        else{
            $user_info = getUserInfo();
            $has_errors = 'true';
            $up['UserPermissions'] =  $this->UserPermissionModel->getUPIndexData();
            $fd['functionalityData'] =  $this->UserPermissionModel->getFunData();
            $ur['User Roles'] =  $this->URmodel->getUrolesIndexData();
            $u['Users'] =  $this->Umodel->getUserIndexData();
            $rules['Rules'] = $this->rulmodel->getFunctionalitiesIndexData();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'User Permissions',
                'link' => 'userpermissions',
                'sources' => $up,
                'userroles' =>$ur,
                'users' => $u,
                'rules' => $rules,
                'userinfo' => $user_info,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );   
            return view('userpermissions', $data);
        }

    }

    public function index()
    {
        $user_info = getUserInfo();
        $has_errors = 'false';
        $up['UserPermissions'] =  $this->UserPermissionModel->getUPIndexData();
        $fd['functionalityData'] =  $this->UserPermissionModel->getFunData();
        $ur['User Roles'] =  $this->URmodel->getActiveUserRoleData();
        $u['Users'] =  $this->Umodel->getActiveUserData();
        $rules['Rules'] = $this->rulmodel->getAllActiveFunctionalitydata();
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'User Permissions',
            'link' => 'userpermissions',
            'sources' => $up,
            'userroles' =>$ur,
            'users' => $u,
            'rules' => $rules,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );   

        foreach($up as $rule){
            foreach($rule as $r){
                // echo '<pre>';
                // Split the values and store them in the array
                $splitValues = explode(',',$r['FID']);
                $values[] = $splitValues;
                if(count($values)>1){
                    foreach ($values as $valueArray) {
                        foreach ($valueArray as $value) {
                            $result= $this->rulmodel->getSingleFunctionalityData($value);
                            // print_r($result->FName);
                        }
                    }
                }              
            }
        } 
        // print_r(count($values));
        // print_r($values);
       
        // die();
        return view('userpermissions', $data);
    }   
    //get single data
    public function singleData($id = null) 
    {
        $data= $this->UserPermissionModel->getSingleUserPermissionData($id);       
        if($data){  
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
     //update
     public function update()
     {  

               $id = $this->request->getVar('RBID');
                $data = [
                    'RoleID' => $this->request->getVar('RoleID'),
                    'UserID'  => $this->request->getVar('UserID'),
                    'RBUpdatedAt' => date('Y-m-d H:i:s'),
                    'delete_flag' => '0',
                ];     
                $arrays = $_POST['FID'];  //store all FID values in a array
                $data['FID'] = implode(',',$arrays);  // concatenate them using comma and store 
                foreach($arrays as $array){  
                    $result = $this->rulmodel->getSingleFunctionalityData($array); //get all functionality names  by passing fid 
                    $fnames[]=$result->FName; // store all fnames in a array
                }
                $data['Fnames'] = implode(', ', $fnames); // concatenate them using comma and store
                $result = $this->UserPermissionModel->updatePermission($id, $data);
                if($result) {
                    return $this->response->redirect(site_url('/userpermissions'));
                }
                else{
                    echo "Something went wrong";
                }
      
       
     }
     // delete 
     public function delete($id = null)
     {
        $now = date("Y-m-d H:i:s");
        $data = [
            'RBDeletedAt' => $now,
            'delete_flag' => '1',
        ];
        $this->UserPermissionModel->deleteUserPer($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/suppliers'));
     }

}
