<?php

namespace App\Models;

use CodeIgniter\Model;

class CustomerLoyalties extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'customer_loyalties';
    protected $primaryKey       = 'DelID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['customer_id','sale_id', 'loyalty_percentage', 'amount', 'exp_date', 'is_cash', 'authorized_by', 'auth_code','is_redeemed','created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert data
    function insertData($data)
	{
        return $this->db->table('customer_loyalties')->insert($data);
	}
    //get specific data
    function getSpecificData($id){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->get()->getRow();
    }
    // get all data
    function index(){
        $data= $this->db->table('customer_loyalties')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->set($data)->update();
    }
    // delete delete
    function deleteData($id,$data){
        return $this->db->table('customer_loyalties')->where(["id" => $id])->set($data)->update();
    }
}
