<?php   
namespace App\Models;

use CodeIgniter\Model;

class PaymentModel extends Model{
    protected $DBGroup = 'default';
    protected $table = 'payments';
    protected $primaryKey = 'CusId';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = true;
    protected $allowedFields = ['sale_id', 'customer_id','amount','payment_type_id','bank_id','payment_method_id','card_expiration_date','reference_number','remarks','created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    
    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert data
    function insertData($data)
	{
        return $this->db->table('payments')->insert($data);
	}
    //get specific data
    function getSpecificData($id){
        return $this->db->table('payments')->where(["id" => $id])->get()->getRow();
    }
    // get all data
    function index(){
        $data= $this->db->table('payments')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('payments')->where(["id" => $id])->set($data)->update();
    }
    // delete delete
    function deleteData($id,$data){
        return $this->db->table('payments')->where(["id" => $id])->set($data)->update();
    }
}