<?php

namespace App\Models;

use CodeIgniter\Model;

class UnitsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'units';
    protected $primaryKey       = 'UnitID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['UnitName', 'UnitAbbreviation','base_unit_id','is_base_unit','UnitCreatedAt', 'UnitUpdatedAt', 'UnitDeletedAt', 'current_status','delete_flag','UnitCreatedBy','UnitUpdatedBy','UnitDeletedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'UnitCreatedAt';
    protected $updatedField  = 'UnitUpdatedAt';
    protected $deletedField  = 'UnitDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all units data    
    function getAllActiveUnitsData()
    {
        return $this->db
            ->table('units')
            ->where('delete_flag', '0')
            ->where('current_status', '1')
            ->orderBy('UnitID ', 'ASC')
            ->get()
            ->getResultArray();
    }

    function getIndexData()
    {
        return $this->db
            ->table('units')
            ->where('delete_flag', '0')
            ->orderBy('UnitID ', 'ASC')
            ->get()
            ->getResultArray();
    }
    // save unit data
    function insertUnits($data)
	{      
        return $this->db
            ->table('units')
            ->insert($data);
	}
    
    // get single unit data
    function getSingleUnitData($id)
    {
        return $this->db
            ->table('units')
            ->where(["UnitID" => $id])
            ->get()
            ->getRow();
    }

    // update unit data
    function updateUnits($id, $data)
    {
        return $this->db
            ->table('units')
            ->where(["UnitID" => $id])
            ->set($data)
            ->update();
    }

    // delete unit
    function deleteUnits($id,$data)
    {
        return $this->db
            ->table('units')
            ->where(["UnitID" => $id])
            ->set($data)
            ->update();
    }

     //  status  change
     function statusupdate($id,$data)
     {
            return $this->db
                ->table('units')
                ->where(["UnitID" => $id])
                ->set($data)
                ->update();
     }
     //get active units
     function getActiveUnitsData(){
        return $this->db
            ->table('units')
            ->where('delete_flag', '0')
            ->where('current_status', '1')
            ->orderBy('UnitID ', 'ASC')
            ->get()
            ->getResultArray();
     }
}
