<?php

namespace App\Models;

use CodeIgniter\Model;

class UserRoleModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'userrole';
    protected $primaryKey       = 'URoleID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['URoleID', 'URName', 'URCreatedAt', 'URCreatedBy','URUpdatedAt', 'URUpdatedBy', 'URDeletedAt', 'URDeletedBy', 'current_status','delete_flag'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'URCreatedAt';
    protected $updatedField  = 'URUpdatedAt';
    protected $deletedField  = 'URDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];



    //get all user role data
    public function allUserRole(){
        $this->db->select('URName');
        $query = $this->db->find('URName');

        return $query;
    }


    // get user role data
    public function getUrolesIndexData()
    {

        $data= $this->db
        ->table('userrole')
        ->where('delete_flag', '0')
        ->orderBy('URoleID', 'ASC')
        ->get()
        ->getResultArray();

        return $data;
    }
     // get active user role data
     public function getActiveUserRoleData()
     {

         $data= $this->db
         ->table('userrole')
         ->where('delete_flag', '0')
         ->where('current_status', '1')
         ->orderBy('URoleID', 'ASC')
         ->get()
         ->getResultArray();
 
         return $data;
     }
    // save user role data
    public function insertuRoleData($data)
    {
        return $this->db
        ->table('userrole')
        ->insert($data);
    }

    // get single user role data
    function getSingleuRoleData($id)
    {
        return $this->db
             ->table('userrole')
             ->where(["URoleID" => $id])
             ->get()
             ->getRow();

    }
    // update user role data
    function updateUrole($id,$data)
    {
        return $this->db
        ->table('userrole')
        ->where(["URoleID" => $id])
        ->set($data)
        ->update();

    }
    // delete user role data
    function deleteUrole($id,$data){
        // die();
        return $this->db
        ->table('userrole')
        ->where(["URoleID" => $id])
        ->set($data)
        ->update();

    }
    
     //  status  change
     function statusupdate($id,$data)
     {
            return $this->db
                ->table('userrole')
                ->where(["URoleID" => $id])
                ->set($data)
                ->update();
     }

}
