<?php $this->extend('layouts/master') ?>

<?php $this->section('receivings') ?>
    <!--- Sale Status --->       
    <div class="container-fluid mt-3">
        <?php $validation = \Config\Services::validation(); ?>
    
        <form method="post" id="recForm" enctype="multipart/form-data"  accept-charset="utf-8">
               
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight" style="visibility:hidden;">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Mode</div>
                                            <div class="flex-fill bd-highlight">
                                                <select id="recMode" name="recMode" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                                   <option value="1" selected>Receive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="subtitle-line bg-secondary ms-auto me-auto ml-1 mt-2">
                                    <div class="d-flex bd-highlight ">
                                        <div class="flex-fill bd-highlight">Find/Scan Item </div>
                                        <div class="flex-fill bd-highlight">
                                            <!--input type="text" class="form-control" name="itemSearch" id="itemSearch" placeholder="Items"/>                                            
                                            <ul id="itemSearchResults"></ul-->                                    
                                            <select id="dropdown" class="form-control ms-2 py-0 ps-1 text-secondary fw-bold" aria-label="Default select example">
                                                <option selected disabled>Start Typing item's name</option>                                               
                                                <?php
                                                    if ($sources):
                                                    foreach ($sources as $source):
                                                ?>
                                                        <option value="<?php echo $source['ItemID']; ?>"><?php echo $source['ItemID']; ?>-<?php echo $source['ItemName']; ?></option>
                                                <?php
                                                   endforeach;
                                               endif;
                                               ?>
                                            </select>
                                        </div>
                                        <div class="ps-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                <i class="bi bi-upc-scan"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <?php if($count != '0'){ ?>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Temp Receivings </div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <a class="btn linear-bg text-secondary px-2 py-0" href="/receivingsTempList">
                                                        <?php echo $count; ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table">
                                <div class="tableFixHead mt-2"> 
                                    <table class="table rounded align-middle" id="viewtable">
                                        <thead class="text-center text-secondary rounded">
                                            <!-- <th class="rounded-start" scope="col">Delete</th> -->
                                            <!--th scope="col" id="itemId">Item#</th-->
                                            <th scope="col" id="itemId">Item Name</th>
                                            <!--th scope="col">serial</th-->
                                            <th scope="col">MFD</th>
                                            <th scope="col">EXD</th>
                                            <th scope="col">Cost</th>
                                            <th scope="col">Selling</th>
                                            <th scope="col">Qty</th>
                                            <th scope="col">Unit</th>
                                            <th scope="col">Disc %</th>
                                            <!--th scope="col"></th-->
                                            <th scope="col">Total</th>
                                            <th scope="col" style="display:none" >ramont</th>
                                            <th class="rounded-end" scope="col">Action</th>
                                            <!-- <th class="rounded-end" scope="col">Delete</th> -->
                                        </thead>
                                        <tbody id="table_body" class="text-primary fw-bold">
                                       
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4">                    
                    <div class="linear-bg rounded-15 p-2">
                        <div class="d-flex bd-highlight mb-1">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">Select Supplier (Optional)</div>
                                        <div class="flex-fill bd-highlight">
                                            <select name="supplier" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example" id="supplier">
                                                <?php
                                                    if ($Suppliers):
                                                        foreach ($Suppliers as $Supplier):
                                                ?>
                                                            <option value="<?php echo $Supplier['SupplierID']; ?>"><?php echo $Supplier['SupplierID']; ?>-<?php echo $Supplier['SupplierName']; ?></option>
                                                <?php
                                                        endforeach;
                                                    endif;
                                                ?>
                                            </select>                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">New Supplier</div>
                                        <div class="flex-fill bd-highlight">
                                            <div class="ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#supplierdteModal">
                                                    <i class="bi bi-plus-lg fw-bold"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div-->
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Subtotal</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0" ><input type="text" class="mainform" name="subtot"id="subtot"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">Tax:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" value="90" class="mainform" id="stax1" name="tax3" readonly></td>                                        
                                    </tr>                                    
                                    <tr class="mt-3">
                                        <td class="py-0">Discount:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" value="4" id="stax2" name="tax5"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" name="tot" id="tot"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1 mt-3">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Comments</td>
                                        <td class="text-end py-0">
                                            <input type="text" id="rcomment" name="comments" class="mainform">
                                            <?php if($validation->getError('name')) {?>
                                                <div class='alert alert-danger mt-2'>
                                                <?= $error = $validation->getError('comments'); ?>
                                                </div>
                                            <?php }?>                                         
                                        </td>                                        
                                    </tr>                                    
                                </tbody>
                            </table>
                        </div>
                        <div class="flex-fill bd-highlight">
                            <div class="subtitle-line bg-secondary ml-1 mt-3 mb-1 ">
                                <div class="d-flex bd-highlight">
                                    <div class="flex-fill bd-highlight">Payment type</div>
                                    <div class="flex-fill bd-highlight">
                                        <select id="paytype" name="payType" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                            <option value="1">Cash</option>
                                            <option value="2">Credit</option>                                        
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--input type="hidden" name="ramount" id="ramount">
                        <input type="hidden" name="recMode" id="recMode" class="recModeclass"-->
                        <input type="hidden" name="userId" value="<?php echo $userinfo->UserID; ?>">                               

                        <div class="d-flex bd-highlight mb-1 mt-2">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <!-- <div class="" style="width:50px; height:50px; background-color:red" id="recivingDone">click check value </div> -->
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="submit" id="recivingDone">
                                                Finish 
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <!-- <div class="" style="width:50px; height:50px; background-color:red" id="recivingDone">click check value </div> -->
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" id="finishlater" data-id="tempSave">
                                                Finish Later
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" data-bs-toggle="modal" data-bs-target="#employeeUpdate" data-id=""  id="employeeEdit">
                                                Cancel
                                            </button>
                                        </div>                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                   
                </div>
            </div>
        </form>   
    </div>
    <!--- Item Module --->
    <form id="newRecItemAdd" method="post" enctype="multipart/form-data" accept-charset="utf-8">
        <div class="modal fade" id="itemAddModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Item</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemName" name="ItemName" placeholder="Enter Item Name">
                            </div>                                
                            <div class="mb-3 col">
                                <select class="form-control" name="ItemCategory" id="ItemCategory">
                                    <?php                                        
                                        if($ItemCategories):
                                        foreach($ItemCategories as $ItemCategory):
                                    ?>                                        
                                    <option value="<?php echo $ItemCategory['ICID']; ?>" ><?php echo $ItemCategory['ICName']; ?></option>
                                    
                                    <?php
                                        endforeach;
                                        endif;
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemTags" name="ItemTags" placeholder="Enter Item Tags">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemDescription" name="ItemDescription" placeholder="Enter Item Description">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemUnit" name="ItemUnit" placeholder="Enter Item Unit" />
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemReorderLevel" name="ItemReorderLevel" placeholder="Enter Item Reorder Level">
                            </div>
                        </div>
                        <div class="row">
                            <div class="wrapper col">
                                <div class="box">
                                    <div class="js--image-preview">
                                        <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                    </div>
                                    <div class="upload-options">
                                        <label>
                                            <input type="file" class="image_upload" accept="image/*" name="ItemImg" id="ItemImg ">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col"> 
                                <input class="form-check-input" name="ItemIsSerialized" type="checkbox" value="1" id="ItemIsSerialized">
                                <label class="form-check-label ms-1" for="flexCheckDefault"> : Item Is Serialized </label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer ">
                        <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button> -->
                        <div class="d-flex align-items-start">
                            <button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitRecItemBtn">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!--- Item Module End--->

    <!--- Supplier Module --->
    <div class="modal fade" id="supplierdteModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header linear-bg">
                    <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">New Supplier</h5>
                    <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="first_name" placeholder="Enter First Name">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="last_name" placeholder="Enter Last Name">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="email" class="form-control" id="email" placeholder="Enter Email">
                            </div>
                            <div class="mb-3 col">
                                <input type="phone" class="form-control" id="phone_number" placeholder="Enter Phone Number">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Address_1" placeholder="Enter Address 1">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Address_2" placeholder="Enter Address 2">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="city" placeholder="Enter City">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="state" placeholder="Enter State">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="zip" placeholder="Enter Zip code">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Country" placeholder="Enter Country">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="recipient-name" placeholder="Account #">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Company" placeholder="Enter Company Name">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <textarea class="form-control" id="message-text" placeholder="Enter Comments"></textarea>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer ">
                    <button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                </div>
            </div>
        </div>
    </div>
    <!--- Supplier Module End--->

    <!--- Serialized item module start --->
    <div id="serialpopupspace"></div>
</section>
<?php echo view('includes/footer'); ?>
<!--link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script-->
<!--script type="text/javascript">/* This method will add a new row */
    function delete_row(no)
    {
        document.getElementById("row"+no+"").outerHTML="";
    }

    function add_row()
    {            
        var table=document.getElementById("serialtable");
        var table_len=(table.rows.length)-1;
        var row = table.insertRow(table_len).outerHTML="<tr id='row"+table_len+"'><td><input type='text' class='form-control serialno' name='serialno' id='serialno' /></td><td><input type='text' class='form-control warrenty' name='warrenty' id='warrenty' /></td><td><select class='form-control status' name='status' id='status'><option value='1'>New</option><option value='2'>Used</option><option value='3'>Aging</option><option value='4'>Damaged</option></select></td><td><button type='button' class='btn linear-bg text-secondary delete' value='Delete' onclick='delete_row("+table_len+")'><i class='bi bi bi-trash3-fill'></i></button></td></tr>";
    }
</script-->
<script>
    $(document).ready(function() {            
        //console.log(response);
        // get serial data to table input
        var serialNos = null;
        var groupedSerialData = [];
        
        //check serial data qty and qty - variable assignment
        var serialDataCount = '0';
        var itemqty = '';
        var serialItemQtyStatus = 'false';
        $('#submitSerialDetailBtn').on('click', function(event){
            event.preventDefault();
            serialNos = $('#serializeditemtable input').map(function(index, element) {
                return {
                    Name: $(element).attr('name'),                        
                    Value: $(element).val()
                }
            }).get();
            //console.log(serialNos);
            $.map(serialNos, function(element, index) {
                var groupSerialIndex = Math.floor(index / 6);

                if (groupedSerialData[groupSerialIndex] === undefined) {
                    groupedSerialData[groupSerialIndex] = [];
                }
                
                groupedSerialData[groupSerialIndex].push(element);
            });
            // serial data stored in groupedSerialData
            //console.log(groupedSerialData);
            //$('#serial').val(groupedSerialData);
            $("#newSerItemDetailAdd")[0].reset();
            $("#newitemserialized input").val('');
            $("#newitemserialized").modal("hide");

        });
        //console.log(groupedSerialData);

        $('body').on('click', '#serialItemPopUp', function(){
            $("#newitemserialized").modal("show");
        }); 
        
        const dropdown = document.getElementById('dropdown');
        var tableBody = document.getElementById('table_body');
        const recMode = document.getElementById('recMode');

        // select receiving mode     
        recMode.addEventListener('change', ()=>{
            var recVal = recMode.value;
            //console.log('recVal'+ recVal)
            $(".recModeclass").val(recVal)
        });        
        
        //make item dropdown searchable
        var previous_serial_nos = [];
        $("#dropdown").select2();            
        var selectedOption = '';
        $('#dropdown').on('select2:select', function(e) {
            var selectedOption = e.params.data;                
            var itemId = selectedOption.id;
            //alert(itemId);
            $.ajax({
                url: 'receivings_feeditemdata/'+itemId,
                type: "GET",
                dataType: 'json',
                success: function (response) { 
                    console.log(response); 
                    //console.log(response.items);
                    //console.log(response.itemUnits);
                    //console.log(response.itemSerials);
                    $('#dropdown option[value="' + itemId + '"]').prop('disabled', true);
                    var trHTML = '';
                    var serialpopup = '';
                    // var trHTML1 = '';
                    // var trHTML2 = '';
                    var total = 0;
                    var ramount = 0;
                    var sum = 0;
                    
                    // for(var j = 0; j < response.itemSerials.length; j++){
                    //     console.log(response.itemSerials[j]);
                    //     previous_serial_nos.push(response.itemSerials[j]['serial_number']);
                    // }
                    // var psn_values = previous_serial_nos.join(', ');

                    // check with previous serial nos
                    for(var j = 0; j < response.itemSerials.length; j++){
                        //console.log(response.OriginSerialData[response.recDetailData[i].ItemID][j]);
                        previous_serial_nos.push(response.itemSerials[j]['serial_number']);
                        if (j === response.itemSerials.length - 1) {
                            // Reset variables for the next loop
                            var psn_values = previous_serial_nos.join(', '); 
                            previous_serial_nos = [];
                        }
                    }

                    //console.log(psn_values);
                    //$.each(response.items, function (i, item) {
                        //console.log(item);
                        trHTML += 
                            '<tr id="'+response.items.ItemID+'" class="parent"><td class="nr" style="display:none;">' +response.items.ItemID
                                + '</td><td id="itemName">'
                                if(response.items.ItemIsSerialized == '1'){
                                    trHTML += '<button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#item'+response.items.ItemID+'">'+response.items.ItemName+'</button><input type="hidden" class="serialData" id="serialData'+response.items.ItemID+'">'
                                }else{
                                    trHTML += response.items.ItemName
                                }
                        trHTML  += '<input type="hidden" class="serial" id="serial" value="'+response.items.ItemIsSerialized+'"></td><td>'
                                + '<input type="date" name="mandate" class="manDate" id="rmanDate" style="width:115px">'
                                + '</td><td>'
                                + '<input type="date" name="expdate" class="expDate" id="rexpDate" style="width:115px">'
                                + '</td><td>'
                                if(response.last_cost_price == 0.00){
                                    trHTML += '<input type="text" value="0.00" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice" style="width:40px">'                                    
                                }else{
                                    trHTML += '<input type="text" value="'+response.last_cost_price.purchasing_price+'" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice" style="width:40px">'
                                }
                        trHTML  += '</td><td>'
                                + '<input type="text" value="0.00" name="rItemSellPrice" class="rItemSellPrice" id="rItemSellPrice" style="width:40px">' 
                                + '</td><td>' 
                                + '<input type="text" style="width:25px" name="quantity" class="quantity" id="rItemqty" value="1"><input type="hidden" name="serialitemqty" class="serialitemqty" id="serialitemqty'+response.items.ItemID+'">'
                                + '</td><td>'
                                + '<select style="width:45px" name="unit" class="unit" id="runit">'
                                + '<option value="'+response.items.ItemUnit+'">'+response.items.UnitName+'</option>';
                                $.each(response.itemUnits, function (i, item) { 
                                    trHTML += '<option value="'+item.OtherUnits+'">'+item.UnitName+'</option>'
                                });
                        trHTML += '</select>'
                                + '</td><td>'
                                + '<input type="text" class="discount" style="width:25px" id="rItemDiscount">'
                                + '</td><td>' 
                                + '<input type="text" id="rtotal" value="'+total+'" style="width:80px" class="rtotal">'
                                + '</td><td style="display:none;">'
                                + '<input type="text" id="totramount" style="width:15px" placeholder="ramount" value="'+ramount+'" class="ramount">'
                                + '</td><td>'
                                //+ '<button class="btn linear-bg text-secondary px-2 py-0" id="calitemtotal" data-value="'+response.items.ItemID+'" ><i class="bi bi-check-square-fill"></i></button> | <button class="btn linear-bg text-secondary px-2 py-0" data-id="'+response.items.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'
                                + '<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+response.items.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'
                                + '</td></tr>';

                        serialpopup += '<form id="serialnoform'+response.items.ItemID+'" method="post">'
                                    +'<div class="modal fade serialmodal" id="item'+response.items.ItemID+'" tabindex="-1" aria-labelledby="serialModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">'
                                    + '<div class="modal-dialog">'
                                        + '<div class="modal-content">'
                                            + '<div class="modal-header linear-bg">'
                                                + '<h5 class="modal-title subtitle-line bg-secondary" id="serialModalLabel">Items Serial Nos</h5>'
                                                + '<button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>'
                                            + '</div>'
                                            + '<div class="modal-body">'
                                                + '<div class="tableFixHead mt-2">'
                                                    + '<input class="form-control" type="hidden" id="serialItemID" value="'+response.items.ItemID+'">'
                                                    + '<input class="form-control" type="hidden" id="psn_values'+response.items.ItemID+'" value="'+psn_values+'">'
                                                    + '<table class="table rounded align-middle serialtable'+response.items.ItemID+'" id="serialtable'+response.items.ItemID+'">'
                                                        + '<thead class="text-center text-secondary rounded">'
                                                            + '<th scope="col">Serial No</th>'
                                                            + '<th scope="col">Warrenty Period</th>'
                                                            + '<th scope="col">Status</th>'
                                                            + '<th scope="col">Action</th>'
                                                        + '</thead>'
                                                        + '<tbody id="serialtablebody" class="text-primary fw-bold serialtablebody">'
                                                            + '<tr id="1">'
                                                                + '<td><input type="text" class="form-control serialno" name="serialno" id="serialno" data-id="'+response.items.ItemID+'"/></td>'
                                                                + '<td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td>'
                                                                + '<td><select class="form-control status" name="status" id="status">'
                                                                    +'<option value="1">New</option>'
                                                                    +'<option value="2">Used</option>'
                                                                    +'<option value="3">Aging</option>'
                                                                    +'<option value="4">Damaged</option>'
                                                                +'</select></td>'
                                                                + '<td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id="1"><i class="bi bi bi-trash3-fill"></i></button></td>'
                                                            + '</tr>'
                                                        + '</tbody>'
                                                    + '</table><button type="button" class="btn linear-bg text-secondary" id="addserialrow'+response.items.ItemID+'"><i class="bi bi-plus-lg fw-bold"></i> Add Row</button>'
                                                + '</div>'
                                            + '</div>'
                                            + '<div class="modal-footer ">'
                                                + '<h6 class="text-danger" id="serialErrorMsg"></h6>'
                                                + '<button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="serialsubmit">Submit</button>'
                                            + '</div>'
                                        + '</div>'
                                    + '</div>'
                                + '</div>'
                                + '</form>';

                        $("#table_body").append(trHTML);
                        $("#serialpopupspace").append(serialpopup);
                                    
                        // add new row in serial popup
                        var tableElement = $(".serialtable"+response.items.ItemID+""); 
                        var serialItemID = response.items.ItemID;
                        var serQty = $('#'+serialItemID+' #rItemqty').val();

                        $('#addserialrow'+response.items.ItemID+'').on('click', function() {
                            var lastRow = $('#serialtable'+response.items.ItemID+' #serialtablebody tr:last');
                            var inputs = lastRow.find('.serialno');
                            var isValid = true;
                            var row_count = $('#serialtablebody tr').length;

                            // Check if any input field in the last row is empty
                            inputs.each(function() {
                                var value = $(this).val();
                                if (value === '') {
                                    isValid = false;
                                    return false; // Exit the loop early if any input is empty
                                }
                            });

                            if (isValid) {
                                // Add a new row with empty inputs
                                var newRow = $('<tr id='+row_count+'><td><input type="text" class="form-control serialno" name="serialno" id="serialno" data-id="'+serialItemID+'"/></td><td><input type="text" class="form-control warrenty" name="warrenty" id="warrenty" /></td><td><select class="form-control status" name="status" id="status"><option value="1">New</option><option value="2">Used</option><option value="3">Aging</option><option value="4">Damaged</option></select></td><td><button type="button" class="btn linear-bg text-secondary deleteRow" data-id='+row_count+'><i class="bi bi bi-trash3-fill"></i></button></td></tr>');
                                $('#serialtable'+response.items.ItemID+' #serialtablebody').append(newRow);
                                serQty++;                                
                                $("#"+serialItemID+" #rItemqty").val(serQty);
                            } else {
                                // Handle invalid inputs
                                swal.fire({
                                    title: 'Warning',
                                    text: 'Please fill in all fields',
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                });
                                //console.log('Please fill the all fields');
                            }
                        });

                        $('body').on('click', '.deleteRow', function(e){
                            e.preventDefault();
                            var dID = $(this).attr('data-id');
                            //alert(dID);
                            $('.serialtablebody tr#'+dID+'').remove();
                            serQty--;
                            $("#"+serialItemID+" #rItemqty").val(serQty);
                            //$('tr #'+response.items.ItemID+' #rItemqty').val(serQty);
                        });

                        var serailizedData = [];
                        // get values modal to main table
                        $('body').on('click', '#serialsubmit', function (e) {
                            $('#serialnoform'+response.items.ItemID+' tbody tr').each(function(row, tr){                                    
                                var serialNoInput = $(tr).find('.serialno').val();

                                //console.log(serialNoInput + warrentyInput);
                                if(serialNoInput != ''){
                                    e.preventDefault();
                                    serailizedData[row] ={
                                        "serialno" : $(tr).find('.serialno').val(),
                                        "warrenty" : $(tr).find('.warrenty').val(),
                                        "status" : $(tr).find('.status').val(),
                                    };

                                    //console.log(serailizedData);
                                    var serialtext = JSON.stringify(serailizedData);
                                    var replacement = serialtext.replace(/'/g, '"');
                                    $('#serialData'+response.items.ItemID+'').val(replacement);
                                    //console.log(serialtext);
                                    $('.serialmodal').modal('hide');
                                    //store serial items count seperatly
                                    $("#serialitemqty"+response.items.ItemID+"").val(serailizedData.length);
                                }else{
                                    e.stopPropagation();
                                    $("#serialErrorMsg").text("Empty fields are there!");
                                    //console.log("Empty fields are there!");
                                }
                            });
                        });
                        //console.log(serailizedData);

                        //unique serial nos
                        $("body").on("blur", "#serialno", function(e){
                            e.preventDefault();
                            var current_serial_no = $(this).val();
                            var itemID = $(this).data('id');
                            var pre_serial_nos = $("#psn_values"+itemID+"").val();
                            var pre_serial_nos_paces = pre_serial_nos.replace(/\s/g, '');
                            var pre_serial_array = pre_serial_nos_paces.split(",");
                            //console.log(pre_serial_array);

                            var foundValue = pre_serial_array.find(function(element) {
                                return element === current_serial_no;
                            });

                            if (foundValue !== undefined) {
                                swal.fire({
                                    title: 'Warning',
                                    text: 'Serial No alread exisist',
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonText: 'Ok',
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        $(this).val('');
                                    }
                                });
                            } else {
                                console.log("The search value was not found in the array.");
                            }
                        });

                        $(".rtotal").each(function(){
                            sum += parseInt($(this).closest("tr").find(".rtotal").val());
                            $("#subtot").val(sum);                                                  
                            var netTax= -parseInt($("#stax1").val())+parseInt($("#stax2").val());
                            var tot=parseInt($("#subtot").val())-netTax;
                            $("#tot").val(tot);
                        });

                        $(".ramount").each(function(){
                            ramount += parseInt($(this).closest("tr").find(".ramount").val()); 
                            $("#ramount").val(ramount);
                        });
                    //});
                },                                  
                error: function (data) {
                    //console.log('error');
                }
            });
        });

        //delete receiving record from data table
        $('body').on('click', '#recDel', function () {
            var RecId = $(this).attr('data-id');
            var delVal=parseInt($(this).closest("tr").find(".rtotal").val());
            var totVal=parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
            var subtotVal=parseInt($("#subtot").val());
            var newVal=totVal-delVal;
            var newsubTotVal=subtotVal-delVal;
            //console.log(newVal);
            $("#tot").val(newVal);
            $("#subtot").val(newsubTotVal);
            $(this).closest('tr').remove();
            $('#dropdown option[value="' + RecId + '"]').prop('disabled', false);          
        });  
        
        // add new item to system   
        // $('body').on('click', '#submitRecItemBtn', function(e) {
        //     //   console.log($('#newRecItemAdd').serialize());
        //     e.preventDefault();
        //     var formData = $('#newRecItemAdd').serialize();
        //     var child = null;
        //     //console.log(formData);
        //     $.ajax({
        //         type: 'POST',
        //         url: '/itemsaveandrec', // replace with the actual URL that handles the form submission
        //         data: formData,
        //         dataType: 'json',
        //         success: function(res) {
        //             console.log(res);
        //             console.log(res.data);
        //             $('#itemAddModel').modal('hide');
        //             var id = res.data.ItemID;
        //             var name = res.data.ItemName;
        //             var price = res.data.ItemCostPrice;
        //             // console.log(id);
        //             // console.log(name);
        //             // console.log(price);

        //             if(res.data.ItemIsSerialized==1){
        //                 var child = 'child'
        //                 var newRow2 = $("<tr id='"+id+"' class='child'>");
        //                 var newTD1 = $("<td colspan='12'>");
        //                 newTD1.append($("<table id='child'><tr colspan='12'>"));
        //                 newRow2.append($("<td>").text(name));
        //                 newRow2.append($("<td colspan='10'>").html("<input type='text' class='RefSerialNos' name='RefSerialNos' id='RefSerialNos' placeholder='Serial No' />"));
        //                 newRow2.append($("<td>").html("<button type='button' class='btn linear-bg text-secondary' id='addserialrow1'><i class='bi bi-plus-lg fw-bold'></i></button>"));
        //             }
        //             // create a new row in the table and populate it with the data
        //             var newRow1 = $("<tr id='"+id+"'>");
        //             newRow1.append($("<td style='display:none;'>").text(id));
        //             newRow1.append($("<td>").html(name+'<input type="hidden" style="width:35px" value="'+res.data.ItemIsSerialized+'" class="serial" id="serial">'));
        //             //newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1" class="serial" id="serial">'));
        //             newRow1.append($("<td>").html('<input type="date" name="manDate" class="manDate" id="rmanDate">'));
        //             newRow1.append($("<td>").html('<input type="date" name="expDate" class="expDate" id="rexpDate">'));
        //             newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" name="rItemCostPrice" class="rItemCostPrice" id="rItemCostPrice">'));
        //             newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" name="rItemSellPrice" class="rItemSellPrice" id="rItemSellPrice">'));
        //             newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1" name="quantity" class="quantity" id="qtynew">'));
        //             newRow1.append($("<td>").html('<input type="text" style="width:35px" name="unit" class="unit" id="unit">'));
        //             newRow1.append($("<td>").html('<input type="text" class="discount" style="width:35px" id="discnew">'));
        //             newRow1.append($("<td style='display:none;'>").html('<input type="hidden" id="rnewamountid" class="ramount">'));
        //             newRow1.append($("<td>").html('<input type="text" id="totalnewadd" style="width:80px" value="0" class="rtotal">'));
        //             newRow1.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0 getIdnewadd" id="'+res.data.ItemID+'" data-value="'+res.data.ItemID+'"><i class="bi bi-check-square-fill"></i></button> | <button class="btn linear-bg text-secondary px-2 py-0" data-id="'+res.data.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'));
        //             //newRow1.append(newRow2);                        
                                
        //             $('#viewtable').append(newRow1);
        //             $('#viewtable').append(newRow2);

        //             $('body').on('click', '#addserialrow1', function() {
        //                 // create a new row with two input fields
        //                 // alert('1');
        //                 // var newRow = $('<td>');
        //                 var serailNoInput = $('<input class="RefSerialNos" id="RefSerialNos" name="RefSerialNos">').attr({type: 'text'});
        //                 // newRow.append($('<td>').append(serailNoInput));
                        
        //                 // // add the new row to the table
        //                 $('#viewtable tr:eq(2) td:eq(1)').append(serailNoInput);
        //             });
                                                        
        //         },                                    
        //         error: function (data) {
        //             console.log(data.responseText);
        //             console.log('error');
        //         }
        //     });
        // });

        // subtotal, total calculation
        // $('body').on('click', '#calitemtotal', function(e){
        //     e.preventDefault();
        //     var rowCount = $("#viewtable tr").length;
        //     var id = $(this).data('value');
        //     var total=0;
        //     var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
        //     var qty = $(this).closest('tr').find("#rItemqty").val();
        //     var disc = $(this).closest('tr').find("#rItemDiscount").val();
        //     // alert(costprice);
        //     // alert(qty);
        //     // alert(disc);
        //     var ramount = costprice*qty;
        //     if(disc){
        //         var total = ramount - (ramount * (disc/100));
        //         $(this).closest('tr').find('#rtotal').val(parseInt(total));
        //     }else{                    
        //         $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
        //     }

        //     var sum = 0;
        //     $(".rtotal").each(function(){
        //         sum += parseInt($(this).closest("tr").find(".rtotal").val());
        //         $("#subtot").val(sum);  
        //         //console.log(sum);                                                
        //         var netTax = parseInt($("#stax1").val()) + parseInt($("#stax2").val());
        //         var tot = parseInt($("#subtot").val()) - netTax;
        //         $("#tot").val(tot);
        //     });
        // });
        $('body').on('blur', '#rItemCostPrice', function(e){
            e.preventDefault();
            var rowCount = $("#viewtable tr").length;
            var id = $(this).data('value');
            var total = 0;
            var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
            var qty = $(this).closest('tr').find("#rItemqty").val();
            var disc = $(this).closest('tr').find("#rItemDiscount").val();
            // alert(costprice);
            // alert(qty);
            // alert(disc);
            var ramount = costprice*qty;
            if(disc){
                var total = ramount - (ramount * (disc/100));
                $(this).closest('tr').find('#rtotal').val(parseInt(total));
            }else{                    
                $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
            }

            var sum = 0;
            $(".rtotal").each(function(){
                sum += parseInt($(this).closest("tr").find(".rtotal").val());
                $("#subtot").val(sum);  
                //console.log(sum);                                                
                var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                var tot = parseInt($("#subtot").val()) + netTax;
                $("#tot").val(tot);
            });
        });

        $('body').on('blur', '#rItemqty', function(e){
            e.preventDefault();
            var rowCount = $("#viewtable tr").length;
            var id = $(this).data('value');
            var total = 0;
            var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
            var qty = $(this).closest('tr').find("#rItemqty").val();
            var disc = $(this).closest('tr').find("#rItemDiscount").val();
            // alert(costprice);
            // alert(qty);
            // alert(disc);
            var ramount = costprice*qty;
            if(disc){
                var total = ramount - (ramount * (disc/100));
                $(this).closest('tr').find('#rtotal').val(parseInt(total));
            }else{                    
                $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
            }

            var sum = 0;
            $(".rtotal").each(function(){
                sum += parseInt($(this).closest("tr").find(".rtotal").val());
                $("#subtot").val(sum);  
                //console.log(sum);                                                
                var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                var tot = parseInt($("#subtot").val()) + netTax;
                $("#tot").val(tot);
            });
        });        

        $('body').on('blur', '#rItemDiscount', function(e){
            e.preventDefault();
            var rowCount = $("#viewtable tr").length;
            var id = $(this).data('value');
            var total = 0;
            var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
            var qty = $(this).closest('tr').find("#rItemqty").val();
            var disc = $(this).closest('tr').find("#rItemDiscount").val();
            // alert(costprice);
            // alert(qty);
            // alert(disc);
            var ramount = costprice*qty;
            if(disc){
                var total = ramount - (ramount * (disc/100));
                $(this).closest('tr').find('#rtotal').val(parseInt(total));
            }else{                    
                $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
            }

            var sum = 0;
            $(".rtotal").each(function(){
                sum += parseInt($(this).closest("tr").find(".rtotal").val());
                $("#subtot").val(sum);  
                //console.log(sum);                                                
                var netTax = -parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                var tot = parseInt($("#subtot").val()) + netTax;
                $("#tot").val(tot);
            });
        });

        //delete receiving record from data table
        $('body').on('click', '#recDel', function () {
            var RecId = $(this).attr('data-id');
            var delVal = parseInt($(this).closest("tr").find(".rtotal").val());
            var totVal = parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
            var subtotVal = parseInt($("#subtot").val());
            var newVal = totVal-delVal;
            var newsubTotVal = subtotVal-delVal;
            //console.log(newVal);
            $("#tot").val(newVal);
            $("#subtot").val(newsubTotVal);
            $(this).closest('tr').remove();           
        });

        //validations
        var valid = '';
        var pricevalid = '';
        var emptyvalid = '';

        //Serial Item Qty and Total Qty Validation Check
        function validateSerialQty(serialItem, totQty) {
            if(serialItem != 0 && totQty != 0){                
                if (serialItem != totQty) {
                    valid = false;
                    swal.fire({
                        title: 'Warning',
                        text: 'No of Serial data not match to given Qty',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'Ok',
                    });
                } else {
                    valid = true;
                }
            }else{
                if(serialItem == 0){
                    valid = false;
                    swal.fire({
                        title: 'Warning',
                        text: 'Serial Items not entered yet',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'Ok',
                    });
                }
                
                if(totQty == 0){
                    valid = false;
                    swal.fire({
                        title: 'Warning',
                        text: 'Serial Items not entered yet',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'Ok',
                    });
                }
            }
        }
        
        //Cost Price empty checking
        function emptyCostPriceCheck(costPrice){
            if(costPrice == 0.00 || costPrice == '0.00' || costPrice == '0'){
                pricevalid = false;
                swal.fire({
                    title: 'Empty field Detected',
                    text: "Please check the Cost Price & Selling Price",
                    icon: 'error'
                });
            }else{
                pricevalid = true;
            }
        }

        //empty check validations - supplier
        function supplierEmptyCheck(){
            var supplierData = $("#supplier").val();

            if(supplierData == ''){
                emptyvalid = false;
                swal.fire({
                    title: 'Empty field Detected',
                    text: "Please select the Supplier",
                    icon: 'error'
                });
            }else{
                emptyvalid = true;
            }
        }

        //empty check validations - sub total
        function subTotalEmptyCheck(){
            var subTotal = $("#subtot").val();

            if(subTotal == '' || subTotal == '0.00'){
                emptyvalid = false;
                swal.fire({
                    title: 'Empty field Detected',
                    text: "Please check the Sub Total",
                    icon: 'error'
                });
            }else{
                emptyvalid = true;
            }
        }
        
        //empty check validations - total
        function totalEmptyCheck(){
            var Total = $("#tot").val();

            if(Total == '' || Total == '0.00'){
                emptyvalid = false;
                swal.fire({
                    title: 'Empty field Detected',
                    text: "Please check the Total",
                    icon: 'error'
                });
            }else{
                emptyvalid = true;
            }
        }

        //empty check validations - Payment Type
        function payTypeEmptyCheck(){
            var payType = $("#paytype").val();

            if(payType == '' || payType == '0'){
                emptyvalid = false;
                swal.fire({
                    title: 'Empty field Detected',
                    text: "Please select the Payment Type",
                    icon: 'error'
                });
            }else{
                emptyvalid = true;
            }
        }
        
        //empty check validations - serial data
        function serialDataEmptyCheck(){
            $('#viewtable tbody tr[class="parent"]').each(function(row, tr){
                var isSerialData = $(tr).find('.serialData').val();
                if(isSerialData == ''){
                    valid = false;
                    swal.fire({
                        title: 'Empty field Detected',
                        text: "Please check the Serial Nos",
                        icon: 'error'
                    });
                }else{
                    valid = true;
                }
            });
        }

        //Total Qty blur validation
        $('body').on('blur', '#rItemqty', function(){
            $('#viewtable tbody tr[class="parent"]').each(function(row, tr){
                var isSerial = $(tr).find('.serial').val();
                var serialCounts = $(tr).find('.serialitemqty').val();
                //alert(serialCounts);
                var totQty = $(tr).find('.quantity').val();
                //alert(totQty);
                //alert(serialCounts);
                if(isSerial != '0'){
                    validateSerialQty(serialCounts, totQty);
                }
            });
        });

        var tableData = [];
        var serialData = '';

        // pass table data to controller
        $('body').on('submit', '#recForm', function(e) {
            e.preventDefault();
            var hasSerialDataStatus  = '';
            $('#viewtable tbody tr[class="parent"]').each(function(row, tr){ 
                var hasserial = $(tr).find('.serial').val();
                //alert(hasserial);
                
                if($(tr).find('.serial').val() == '1'){
                    serialData = $(tr).find('.serialData').val();
                }else{                    
                    serialData = '';
                }
                tableData[row] ={
                    "serialData" : serialData,
                    "itemid" : $(tr).find('td:eq(0)').text(),
                    "name" : $(tr).find('td:eq(1)').text(),
                    "serialized" : $(tr).find('.serial').val(),
                    "expDate" : $(tr).find('.expDate').val(),
                    "manDate" : $(tr).find('.manDate').val(),
                    "price" : $(tr).find('.rItemCostPrice').val(),
                    "sellprice" : $(tr).find('.rItemSellPrice').val(),
                    "qty" : $(tr).find('.quantity').val(),
                    "unit" : $(tr).find('.unit').val(),
                    "ramount" : $(tr).find('.rtotal').val(),
                    "disc" : $(tr).find('.discount').val(),
                };

                //Cost Price Validation
                var costP = $(this).find(".rItemCostPrice").val();
                emptyCostPriceCheck(costP);
                    
                //Serial Item Qty & Total Qty Validation
                var isSerial = $(tr).find('.serial').val();
                var totQty = $(tr).find('.quantity').val(); 
                var serialCounts = $(tr).find('.serialitemqty').val();                    
                if(isSerial != '0'){
                    validateSerialQty(serialCounts, totQty);
                }else{
                    valid = true;
                }

                //empty check validation
                supplierEmptyCheck();
                subTotalEmptyCheck();
                totalEmptyCheck();
                payTypeEmptyCheck();
                //serialDataEmptyCheck();
            });
            
            //alert(hasserial);
            var frmData = $("#recForm").serialize();

            //alert(valid);
            if(valid && pricevalid && emptyvalid){
                //if(tableData != ''){
                    $.ajax({
                        url: '/recevingfinish',
                        type: "POST",
                        data: { 
                            tableData: tableData,
                            frmData:frmData,
                        },
                        //dataType: "json",
                        success: function(response) {
                            //console.log(frm_data);
                            //console.log(response);
                            //console.log(response.message);
                            var rec_id = response.message;
                            //console.log(rec_id);
                            swal.fire({
                                title: response.title,
                                text: response.text,
                                icon: response.icon,
                                showCancelButton: true,
                                confirmButtonText: 'View',
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    // window.location.href = '/view_sales/'+sale_id;
                                    window.open('/receivings_view/'+rec_id, '_blank');
                                }
                                else{
                                    window.location.href = '/receivings'
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            console.error('Error saving table data:',xhr.responseText);
                            console.error('xhr',xhr);
                            console.error('status',status);
                            console.error('error',error);
                            //console.log(frm_data);  
                        }
                    });
                // }else{                        
                //     swal.fire({
                //         title: 'Empty field Detected',
                //         text: "Please check serial items",
                //         icon: 'error'
                //     });
                // }
            }
        });

        // pass data to temproary table
        $('body').on('click', '#finishlater', function(e) {
            e.preventDefault();
            var frmData = $("#recForm").serialize();
            var tableData = [];
            $('#viewtable tbody tr[class="parent"]').each(function(row, tr){ 
                var hasserial = $(tr).find('.serial').val();
                if($(tr).find('.serial').val() == '1'){
                    serialData = $(tr).find('.serialData').val();
                }else{                    
                    serialData = '';
                }
                tableData[row] ={
                    "serialData" : serialData,
                    "itemid" : $(tr).find('td:eq(0)').text(),
                    "name" : $(tr).find('td:eq(1)').text(),
                    "serialized" : $(tr).find('.serial').val(),
                    "expDate" : $(tr).find('.expDate').val(),
                    "manDate" : $(tr).find('.manDate').val(),
                    "price" : $(tr).find('.rItemCostPrice').val(),
                    "sellprice" : $(tr).find('.rItemSellPrice').val(),
                    "qty" : $(tr).find('.quantity').val(),
                    "unit" : $(tr).find('.unit').val(),
                    "ramount" : $(tr).find('.rtotal').val(),
                    "disc" : $(tr).find('.discount').val(),
                };
            });
            $.ajax({
                url: '/receivingSerialTempSave',
                type: "POST",
                data: { 
                    tableData: tableData,
                    frmData: frmData,
                },
                dataType: "json",
                success: function(response) {
                    //console.log(response);
                    swal.fire({
                        title: response.title,
                        text: response.text,
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'Ok',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = '/receivingsTempList'
                        }
                    });
                },
                error: function(xhr, status, error) {
                    console.error('Error saving table data:',xhr.responseText);
                    //console.error('xhr',xhr);
                    // console.error('status',status);
                    console.error('error',error);
                    //console.log(frm_data);  
                }
            });
        });
        
        //$('.manDate').on('change', function() {
        $("body").on("change", ".manDate", function () {
            var myDate = new Date($(this).val());
            var d = new Date(myDate),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();

            if (month.length < 2) month = '0'+ month;
            if (day.length < 2) day = '0'+day;

            var minDate = [year, month, day].join('-');
            //alert(minDate);
            $(".expDate").attr('min',minDate);
            var expDate = $(".expDate").val();
            //alert(expDate);
            if(expDate < minDate){
                $(".expDate").val("");
            }
        });
    });
</script>
<?php $this->endSection() ?>