<?php $this->extend('layouts/master') ?>

<?php $this->section('userroles') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#addurModal"><i class="bi bi-plus-lg fw-bold"></i> New User Roles </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">User Roles</th>
                                            <th class="p-2" scope="col">Status</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s):   
                                            ?>
                                            <tr id="<?php echo $s['URoleID']; ?>">     
                                                <td><?php echo $s['URName']; ?></td>
                                                <td>
                                                        <?php 
                                                            if($s['current_status'] == '1'):
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="enable" data-id="<?php echo  $s['URoleID']; ?>" checked/>
                                                            </div>
                                                        <?php
                                                            else:
                                                        ?>
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input" type="checkbox" role="switch" id="disable" data-id="<?php echo  $s['URoleID']; ?>" />
                                                            </div>
                                                        <?php
                                                            endif;
                                                        ?>
                                                </td>  
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="uredit" type="button" data-bs-toggle="modal" data-bs-target="#addurModal" data-id="<?php echo $s['URoleID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="urdelete" type="button" data-id="<?php echo $s['URoleID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start  user role insert and update model  -->
        <div class="modal fade" id="addurModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> User Roles Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add_ur" name="add_ur" action="<?= site_url('/submit_userrole') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                   <label for="urole" class="col-form-label">Enter User Role:</label>
                                   <input class="form-control" name="URoleID" id="URoleID" placeholder="Enter User Role ID" hidden  value="<?php echo set_value('URoleID');?>">
                                    <input type="text" class="form-control" name="URName" value="<?php echo set_value('URName');?>" id="URName" placeholder="Enter User Role">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'URName') : '' ?></h6>
                                </div>
                            </div>                   
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold"  id="submit" >Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!---End  user role insert and update model ---> 
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');
        $icon = $session->getFlashdata('icon');
        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: '$icon',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
        function openUroleModal()
        {
                var userRole_modal = $("#addurModal");
                var has_errors = $("#has_errors").val();
                if(has_errors == 'true'){
                    userRole_modal.modal('show');
                }
        }
        $(document).ready(function()
        {
            openUroleModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            URTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                URTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    URTable.rows().select();        
                } else {
                    URTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        //Check All
        function checkAll(o) 
        {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
        //update urole
        $('body').on('click', '#uredit', function ()
         {
            var urid = $(this).attr('data-id');
            $.ajax({
                url: 'userrole_edit/'+urid,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#addurModal').modal('show');
                    $('#add_ur #URoleID').val(res.data.URoleID); 
                    $('#add_ur #URName').val(res.data.URName); 
                },
                    error: function (data) {
                }
            });
        });
        //delete urole
         $('body').on('click', '#urdelete', function ()
          {
                var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $.get('userrole_delete/'+id, function (data) {
                if(data.error)
                    // alert('Can not delete, this record has related information');    
                    swal.fire({
                        title: 'Can not delete',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonText: 'OK',
		            });
                else
                    swal.fire({
                        title: 'Deleted',
                        text: "This record has deleted Successfully!",
                        icon: 'success',
                        showCancelButton: false,
                        confirmButtonText: 'OK',                       
                    }).then((result) => {
                        location.reload();
                        $('#viewtable tbody #'+ id).remove();
                    });
                  
                      })
                }
            });          
         });
        //user role enable
        $('body').on('change', '#disable', function () 
        {
            var id = $(this).attr('data-id');
            //  alert(id);
            $.getJSON('enable_user_role/'+id, function (data) {                
              location.reload();
                    })
        });
        //user role disable 
         $('body').on('change', '#enable', function () 
        {
            var id = $(this).attr('data-id');
            // alert(id);
            $.getJSON('disable_user_role/'+id, function (data) {
                location.reload();
            })
        });
         //reset form
         $('#addurModal').on('hidden.bs.modal', function (e) 
         {
            // Clear the form fields
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
         });
        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() 
        {
            document.querySelector('#submit').disabled = true;
        });
                    
    </script>
<?php $this->endSection() ?>