<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Employee extends Migration
{
    public function up()
    {
        //Create Employee Table
        $this->forge->addField([
            'EmpID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'EmpImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],            
            'EmpName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpDesignation' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpDateofBirth' => [
                'type' => 'Date',
            ],
            'EmpNICNo' => [
                'type' => 'varchar',
                'constraint' => 15,
                'unique'     => true,
            ],
            'EmpAddressLine1' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'EmpAddressLine2' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'EmpCity' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpProvince' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpCountry' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpContactNo' => [
                'type' => 'varchar',
                'constraint' => 15,
                'unique'     => true,
            ],
            'EmpEmail' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'EmpAltContactPerson' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'EmpAltNICNo' => [
                'type' => 'varchar',
                'constraint' => 15,
                'null' => true,
            ],
            'EmpAltContactNo' => [
                'type' => 'varchar',
                'constraint' => 15,
                'null' => true,
            ],
            'EmpCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'EmpUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'EmpDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('EmpID');
        $this->forge->createTable('employee');
    }

    public function down()
    {
        //Drop Employee Table
        $this->forge->dropTable('employee');
    }
}
