<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class PriceRules extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'pr_id'=>[
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'pr_type'=>[
                'type' => 'varchar',
                'constraint' => 50,
            ],
            'pr_name'=>[
                'type' => 'varchar',
                'constraint' => 50,
            ],
            'pr_value'=>[
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'pr_items'=>[
                'type' => 'INT'
            ],
            'pr_bank'=> [
                'type' => 'INT'
            ],
            'pr_rate'=> [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'pr_started_date'=> [
                'type' => 'DATE',
                'null' => true,
            ],
            'pr_end_date'=> [
                'type' => 'DATE',
                'null' => true,
            ],
            'pr_created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'pr_updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'pr_deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'pr_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ],

        ]);

        $this->forge->addPrimaryKey('pr_id');
        $this->forge->createTable('price_rules');
    }

    public function down()
    {
        //Drop Table
        $this->forge->dropTable('price_rules');
    }
}
