<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class DiscountMethod extends Migration
{
    public function up()
    {
         //Create discount_methods Table
         $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'discount_method' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'created_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'updated_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'deleted_at'=> [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_by'=> [
                'type' => 'INT',
                'null' => true,
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('discount_methods');
    }

    public function down()
    {
          //Drop Table
          $this->forge->dropTable('discount_methods');
    }
}
