<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */


// We get a performance increase by specifying the default
// route since we don't have to scan directories.

//Already Logged In
$routes->group('', ['filter'=>'AlreadyLoggedIn'], function($routes){
    //login
    $routes->get('/', 'Auth::index');
    $routes->get('/auth', 'Auth::index');
    $routes->post('/check', 'Auth::check');
});

//authentication
$routes->group('', ['filter'=>'AuthCheck'], function($routes){
    //----------------------routes: start ----------------------------------------
    //--home route--
    $routes->get('/index', 'Home::index');
    //--logout route--
    $routes->get('/logout', 'Auth::logout');
    //--user routes--
    $routes->get('/user', 'UserController::getUsers');
    //--sale routes--
    $routes->get('/sales', 'SalesController::index');
    //--supplier routes--
    $routes->get('/suppliers', 'SuppliersController::index');
    $routes->post('/supplierSave', 'SuppliersController::save');
    $routes->get('supplier/edit/(:num)', 'SuppliersController::singleData/$1');
    $routes->post('supplier/update', 'SuppliersController::update');
    $routes->get('supplier/delete/(:num)', 'SuppliersController::delete/$1');
    //--manufacturer routes--
    $routes->get('/manufacturers', 'ManufacturerController::index');
    $routes->post('/manufactureSave', 'ManufacturerController::save');
    $routes->get('manufacture/edit/(:num)', 'ManufacturerController::singleData/$1');
    $routes->post('manufacturer/update', 'ManufacturerController::update');
    $routes->get('manufacturer/delete/(:num)', 'ManufacturerController::delete/$1');
    //--employee routes--
    $routes->get('/employees', 'EmployeeController::index');
    $routes->post('/employeesave', 'EmployeeController::save');
    $routes->get('employees/edit/(:num)', 'EmployeeController::singleData/$1');
    $routes->post('employee/update', 'EmployeeController::update');
    $routes->get('employee/delete/(:num)', 'EmployeeController::delete/$1');
    //--item routes--
    $routes->get('/items', 'ItemsController::index');
    $routes->post('/itemsave', 'ItemsController::save');
    $routes->get('itemedit/(:num)', 'ItemsController::singleData/$1');
    $routes->post('item/update', 'ItemsController::update');
    $routes->get('item/delete/(:num)', 'ItemsController::delete/$1');
    $routes->get('offserialize/(:num)', 'ItemsController::offserialize/$1');
    $routes->get('onserialize/(:num)', 'ItemsController::onserialize/$1');
    $routes->get('disableitem/(:num)', 'ItemsController::disableitem/$1');
    $routes->get('enableitem/(:num)', 'ItemsController::enableitem/$1');
    $routes->get('item/get-item-data/(:num)', 'ItemsController::getItemData/$1');
    //--category routes--
    $routes->post('/insertCategory', 'ItemCategoryController::insert');
    $routes->get('icedit/(:num)', 'ItemCategoryController::singleData/$1');
    $routes->get('icdelete/(:num)', 'ItemCategoryController::delete/$1');
// --catergory information --
    $routes->get('/item_category_information', 'ItemsCategoryInfomationController::index');
    $routes->post('/insertCategoryinfo', 'ItemsCategoryInfomationController::insert');
    $routes->get('/item_category_infomation/edit/(:num)', 'ItemsCategoryInfomationController::singleData/$1');
    $routes->post('/updateCategoryinfo', 'ItemsCategoryInfomationController::update');
    $routes->get('item_category_infomation/delete/(:num)', 'ItemsCategoryInfomationController::delete/$1');

    //--report routes--
    $routes->get('/reports', 'ReportsController::index');
    //--receiving routes--
    $routes->get('/receivings', 'ReceivingsController::index');
    $routes->get('receivings/feeditemdata/(:num)', 'ReceivingsController::singleItemData/$1');
    $routes->get(' receiving/delete/(:num)', 'ReceivingsController::delete/$1');
    $routes->post('/itemsaveandrec', 'ItemsController::saveandrec');
    $routes->post('/recevingfinish', 'ReceivingsController::saveRecItem');
    //--config routes--
    $routes->get('/config', 'ConfigController::index');
    //--bank routes--
    $routes->get('/banks', 'BanksController::index');
    $routes->post('/submitBanks', 'BanksController::insert');
    $routes->get('banks/edit/(:num)', 'BanksController::singleData/$1');
    $routes->get('banks/delete/(:num)', 'BanksController::delete/$1');
    //--functionality routes--
    $routes->get('/functionality', 'FunctionalityController::index');
    $routes->post('/submitFunctionality', 'FunctionalityController::insert');
    $routes->get('functionality/edit/(:num)', 'FunctionalityController::singleData/$1');
    $routes->get('functionality/delete/(:num)', 'FunctionalityController::delete/$1');
    //--user role routes--
    $routes->get('/userroles', 'UserRoleController::index');
    $routes->post('/submitUr', 'UserRoleController::insert');
    $routes->get('ur/edit/(:num)', 'UserRoleController::singleData/$1');
    $routes->get('ur/delete/(:num)', 'UserRoleController::delete/$1');
    //--user permission routes--
    $routes->get('/userpermissions', 'UserPermissionsController::index');
    $routes->post('/submitUp', 'UserPermissionsController::insert');
    $routes->get('up/edit/(:num)', 'UserPermissionsController::singleData/$1');
    $routes->post('uPupdate', 'UserPermissionsController::update');
    $routes->get('permission/delete/(:num)', 'UserPermissionsController::delete/$1');
    //--tenant routes--
    $routes->get('/tenant', 'TenantController::index');
    $routes->post('/tenantreg', 'TenantController::register');
    // $routes->get('/tenantthank', 'TenantController::thankyou');
    //-- Bin Locations - Location Based--
    $routes->get('/locations', 'LocationsController::index');
    $routes->post('/locationinsert', 'LocationsController::locationInsert');
    $routes->get('/locationdelete/(:num)', 'LocationsController::locationDelete/$1');
    $routes->get('/locationSingleData/(:num)', 'LocationsController::locationSingleData/$1');
    //-- Bin Locations - Bin Based--
    $routes->post('/bininsert', 'LocationsController::binInsert');
    $routes->get('/bindelete/(:num)', 'LocationsController::binDelete/$1');
    $routes->get('/binSingleData/(:num)', 'LocationsController::binSingleData/$1');
    //--customer routes--
    $routes->get('/customer', 'CustomerController::index');
    $routes->post('submit-customer', 'CustomerController::submit');
    $routes->get('customer/edit/(:num)', 'CustomerController::getSpecificData/$1');
    $routes->get('customer/delete/(:num)', 'CustomerController::delete/$1');
    //--customer contact info routes--
    $routes->get('/customer_contact_information', 'CustomerContactInformationController::index');
    $routes->post('submit-customer_contact_information', 'CustomerContactInformationController::submit');
    $routes->get('customer_contact_information/edit/(:num)', 'CustomerContactInformationController::getSpecificData/$1');
    $routes->get('customer_contact_information/delete/(:num)', 'CustomerContactInformationController::delete/$1');
    //--delivery routes--
    $routes->get('/delivery', 'DeliveryController::index');
    $routes->post('submit-delivery', 'DeliveryController::submit');
    $routes->get('delivery/edit/(:num)', 'DeliveryController::getSpecificData/$1');
    $routes->get('delivery/delete/(:num)', 'DeliveryController::delete/$1');
    //--loyalties routes--
    $routes->get('/loyalties', 'LoyaltiesController::index');
    $routes->post('submit-loyalties', 'LoyaltiesController::submit');
    $routes->get('loyalties/edit/(:num)', 'LoyaltiesController::getSpecificData/$1');
    $routes->get('loyalties/delete/(:num)', 'LoyaltiesController::delete/$1');
    //--terminal routes--
    $routes->get('/terminal', 'TerminalController::index');
    $routes->post('submit-terminal', 'TerminalController::submit');
    $routes->get('terminal/edit/(:num)', 'TerminalController::getSpecificData/$1');
    $routes->get('terminal/delete/(:num)', 'TerminalController::delete/$1');
    //----------------------routes: end ----------------------------------------
    // /uPupdate
    //sales
    $routes->resource('Api/sales');
    //users
    $routes->resource('Api/user');
    //supplier
    $routes->resource('Api/supplier');
    //inventory
    $routes->resource('Api/inventory');
    // unit and measure
    $routes->get('/unitandmeatures', 'UnitandMeaturesController::index');
    $routes->post('/addupunit', 'UnitandMeaturesController::addupUnits');
    $routes->get('/unitedit/(:num)', 'UnitandMeaturesController::singleUnits/$1');
    $routes->get('/unitdeleted/(:num)', 'UnitandMeaturesController::deleteUnit/$1');
    // conversion factors
    $routes->get('/conversion_factor', 'ConversionFactorController::index');
    $routes->post('/submit', 'ConversionFactorController::addupCFs');
    $routes->get('cfedit/(:num)', 'ConversionFactorController::singleCFs/$1');
    $routes->get('cfdelete/(:num)', 'ConversionFactorController::deleteCF/$1');
    
    
    
    
});

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
