<?php

namespace App\Controllers;

use App\Models\ItemLocationsModel;
use App\Models\ItemBinsModel;
use App\Controllers\BaseController;

class ItemLocationsController extends BaseController
{   
    private $ItemLocationsModel = null;
    private $ItemBinsModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ItemLocationsModel = new ItemLocationsModel();
        $this->ItemBinsModel = new ItemBinsModel();
        $this->now = date("Y-m-d H:i:s");
    }

    public function index()
    {
        $ItemLocations = $this->ItemLocationsModel->getAllLocations();
        $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
        $data = array(
            'ItemLocations' => $ItemLocations,
            'ItemLocationBins' => $ItemLocationBins
        );
        return view($data);
    }
    
    // insert data
    public function insert()
    {
        $validation = $this->validate([
            'LocationName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select employee',
                    'greater_than'=>'Please select employee',
                ],
            ],
            'Item' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select employee',
                    'greater_than'=>'Please select employee',
                ],
            ],
            'BatchNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select employee',
                    'greater_than'=>'Please select employee',
                ],
            ],
            'QtyLevel' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select employee',
                    'greater_than'=>'Please select employee',
                ],
            ],
        ]);
        
        $itemlocationid = $this->request->getVar('locid');
        
        if($validation){
            if($itemlocationid == ''){  //Insert Item Location
                $data = [
                    'LocationID' => $this->request->getVar('LocationName'),
                    'ItemID'  =>  $this->request->getVar('Item'),
                    'BatchNo'  => $this->request->getVar('BatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('QtyLevel'),
                    'ILStatus' => '1',
                    'ILCreaterAt' => $this->now,
                ];
                $this->ItemLocationsModel->insertLocations($data);
            }else{   //Update Item Location
                $data = [
                    'LocationID' => $this->request->getVar('LocationName'),
                    'ItemID'  =>  $this->request->getVar('Item'),
                    'BatchNo'  => $this->request->getVar('BatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('QtyLevel'),
                    'ILUpdatedAt' => $this->now,
                ];
                $this->ItemLocationsModel->updateItemLocations($itemlocationid, $data);
            }
        }
        return $this->response->redirect(site_url('/locations'));
    } 
    
    //get single data
    public function singleData($id = null) 
    {        
        $data=$this->ItemLocationsModel->getSingleLocationData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $data = [
            'ICDeletedAt' => $this->now,
            'ICStatus' => '0',
        ];

        $this->ItemLocationsModel->deleteItemLocations($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
