<?php

namespace App\Controllers;

use App\Models\ItemCategoryModel;
use App\Models\ItemsCategoryInfomationModel;
use App\Models\ItemsCategoryDetailsModel;
use App\Controllers\BaseController;

class ItemsCategoryInfomationController extends BaseController
{

    public function __construct()
    {   
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->itemCategoryInformationModel = new ItemsCategoryInfomationModel(); 
        $this->itemCategoryDetailModel= new  ItemsCategoryDetailsModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form']);
    }

    public function index()
    {
        helper('app'); 
        $user_info = getUserInfo();
        $records['categoryInfo'] = $this->itemCategoryInformationModel->index();
        $has_errors = 'false';
        $data = [
            'breadcrumbs' => 'true',
            'title' => 'CustomerContactInformation',
            'link' => 'customer_contact_information',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        ];
        return view('item_category_information', $data);
    }
    
    public function insert(){        
        $validation = $this->validate([
            'ICName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter category name',
                ],
            ],
        ]);
        if($validation){            
        helper('app'); 
        $user_info = getUserInfo();
        $records['categoryInfo'] = $this->itemCategoryInformationModel->index();
        $data = [
                'ICName' => $this->request->getVar('ICName'),
                'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                'ICParentID'  => $this->request->getVar('ICParentID'),
                'ICCreatedAt' => $this->now,              
                'ICStatus'=>'1',
            ];                      
            $db = \Config\Database::connect(); 
            $this->itemCategoryInformationModel->insertData($data);
            $lastInsertedCatID = $db->insertID();           
            $catcheck = $this->itemCategoryInformationModel->getCatCheckData($lastInsertedCatID);    
            $parentID = $catcheck->ICParentID;
            if($parentID == '0'){
                $path = $this->request->getVar('ICName');  
            }else{                
                $parentCheck = $this->itemCategoryInformationModel->getCatCheckData($parentID);
                $path = $parentCheck->ICName;
            }
            if($lastInsertedCatID){
                $catdetailsdata = [
                    'ICID' => $lastInsertedCatID,
                    'ICPath' => $path,
                    'ICLink' => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                    'ICDStatus' => '1',
                ];
                $this->itemCategoryDetailModel->insert($catdetailsdata);
            }
            return $this->response->redirect(site_url('/item_category_information'));
            }
        else{
            helper('app'); 
            $user_info = getUserInfo();
            $records['categoryInfo'] = $this->itemCategoryInformationModel->index();
            $has_errors = 'true';
            $data = [
                'breadcrumbs' => 'true',
                'title' => 'CustomerContactInformation',
                'link' => 'customer_contact_information',
                'sources' => $records,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,              
            ];          
            return view('item_category_information', $data);
        }
    }

    //get specific data
    public function singleData($id = null) {
        $data=$this->itemCategoryInformationModel->getSpecificData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }
    //update data
    public function update(){
        $id = $this->request->getVar('id');
        $data = [
            'ICName' => $this->request->getVar('ICName'),
            'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
            'ICParentID'  => $this->request->getVar('ICParentID'),
            // 'ICStatus' => '1',
            'ICUpdatedAt' => $this->now,              
        ];         
            
        $this->itemCategoryInformationModel->updateData($id, $data);
        return $this->response->redirect(site_url('/item_category_information'));
    }

     // delete data
     public function delete($id = null ){
        $data = [
            'ICDeletedAt' => date("Y-m-d H:i:s"),
            'ICStatus'=>'0',
        ];
        $this->itemCategoryInformationModel->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}