<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\ItemLocationsModel;
use App\Models\ItemBinsModel;

use App\Controllers\BaseController;

class LocationsController extends BaseController
{
    private $ItemLocationsModel = null;
    private $ItemBinsModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ItemLocationsModel = new ItemLocationsModel();
        $this->ItemBinsModel = new ItemBinsModel();
        $this->now = date("Y-m-d H:i:s");   
        helper(['url','form','app']);
    }


    // Location Based - insert data
    public function locationInsert()
    {

        // print_r($_POST);
        // die();
        $validation = $this->validate([
            'LocationName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Location Name',
                ],
            ],
            'Item' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Item',
                ],
            ],
            'BatchNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Batch No',
                ],
            ],
            'QtyLevel' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Location QTY Level',
                ],
            ],
        ]);
        
        $itemlocationid = $this->request->getVar('locid');
        
        if($validation){
            if($itemlocationid == ''){  //Insert Item Location
                $data = [
                    'LocationID' => $this->request->getVar('LocationName'),
                    'ItemID'  =>  $this->request->getVar('Item'),
                    'BatchNo'  => $this->request->getVar('BatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('QtyLevel'),
                    'ILStatus' => '1',
                    'ILCreaterAt' => $this->now,
                ];
               
                $this->ItemLocationsModel->insertLocations($data);
            }else{   //Update Item Location
                $data = [
                    'LocationID' => $this->request->getVar('LocationName'),
                    'ItemID'  =>  $this->request->getVar('Item'),
                    'BatchNo'  => $this->request->getVar('BatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('QtyLevel'),
                    'ILUpdatedAt' => $this->now,
                ];
                $this->ItemLocationsModel->updateItemLocations($itemlocationid, $data);
            }
            return $this->response->redirect(site_url('/locations'));
        }else{
            $user_info = getUserInfo();
            $ItemLocations = $this->ItemLocationsModel->getAllLocations();
            $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Locations',
                'link' => 'locations',
                'ItemLocations' => $ItemLocations,
                'ItemLocationBins' => $ItemLocationBins,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/locations', $data);
        }
    } 

    
    public function index()
    {
        $user_info = getUserInfo();
        $ItemLocations = $this->ItemLocationsModel->getAllLocations();
        $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
        $has_errors = 'false';
        
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Locations',
            'link' => 'locations',
            'ItemLocations' => $ItemLocations,
            'ItemLocationBins' => $ItemLocationBins,
            'userinfo' => $user_info,
            'storingtypes' => 'Bin',
            'has_errors' => $has_errors,
        );
        return view('/locations', $data);
    }
    
    // Location Based - get single data
    public function locationSingleData($id = null) 
    {        
        $data=$this->ItemLocationsModel->getSingleLocationData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    //  Location Based - delete
    public function locationDelete($id = null)
    {
        $data = [
            'ICDeletedAt' => $this->now,
            'ICStatus' => '0',
        ];

        $this->ItemLocationsModel->deleteItemLocations($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }

    // Bin Based - insert data
    public function binInsert()
    {
        $validation = $this->validate([
            'itemBinLocationId' => [
                'rules'=>'required|matches["Default"]',
                'errors'=>[
                    'required'=>'Please select the Location Name',
                    'matches'=>'Default value is not considerable!',
                ],
            ],
            'itemBinLocatonName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Bin Location Name',
                ],
            ],
            'IBItem' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Item',
                ],
            ],
            'IBBatchNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select the Batch No',
                ],
            ],
            'IBQtyLevel' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please Enter the Location QTY Level',
                ],
            ],
        ]);
        if($validation){
            $itembinlocationid = $this->request->getVar('itemBinId');
            if($itembinlocationid == ''){  //Insert Item Location
                $data = [
                    'ILID' => $this->request->getVar('itemBinLocationId'),
                    'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                    'ItemID'  =>  $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'ILQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'IBStatus' => '1',
                    'IBCreaterAt' => $this->now,
                ];
                $this->model->insertLocationBins($data);
            }else{   //Update Item Location
                $data = [
                    'IBName' => $this->request->getVar('itemBinLocationId'),
                    'IBName'  =>  $this->request->getVar('itemBinLocatonName'),
                    'ItemID'  =>  $this->request->getVar('IBItem'),
                    'BatchNo'  => $this->request->getVar('IBBatchNo'),
                    'IBQtyLevel'  => $this->request->getVar('IBQtyLevel'),
                    'IBUpdatedAt' => $this->now,
                ];
                $this->model->updateItemLocationBins($itembinlocationid, $data);
            }
            return $this->response->redirect(site_url('/locations'));
        }else{
            $user_info = getUserInfo();
            $ItemLocations = $this->ItemLocationsModel->getAllLocations();
            $ItemLocationBins = $this->ItemBinsModel->getAllLocationbins();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'Locations',
                'link' => 'locations',
                'ItemLocations' => $ItemLocations,
                'ItemLocationBins' => $ItemLocationBins,
                'userinfo' => $user_info,
                'storingtypes' => 'Bin',
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
            );
            return view('/locations', $data);
        }
    }
    
    // Bin Based - get single data
    public function binSingleData($id = null) 
    {        
        $data=$this->ItemBinsModel->getSingleLocationBinsData($id);
       
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // Bin Based - Delete
    public function binDelete($id = null)
    {
        $data = [
            'IBDeletedAt' => $this->now,
            'IBStatus' => '0',
        ];

        $this->ItemBinsModel->deleteItemLocationBins($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    } 
}
