<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use App\Models\UserModel;
use App\Models\ItemsModel;
use App\Models\SuppliersModel;
use App\Models\ReceivingModel;
use App\Models\ItemCategoryModel;
use App\Models\RDetailModel;
use App\Models\ReceivingSerialDetailModal;

class ReceivingsController extends BaseController
{
    private $ReceivingModel = null;
    private $ItemCategoryModel = null;
    private $RDetailModel = null;
    private $SuppliersModel = null;
    private $ItemsModel = null;
    private $RecevingSerailModel = null;
    private $now = null;

    public function __construct()
    {
        $this->ReceivingModel = new ReceivingModel();
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->RDetailModel = new RDetailModel();
        $this->SuppliersModel = new SuppliersModel();
        $this->ItemsModel = new ItemsModel();
        $this->RecevingSerailModel = new ReceivingSerialDetailModal();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app']);
    }

    public function index()
    {         
        $user_info = getUserInfo();   
        $items = $this->ItemsModel->getItemIndexData();
        $ItemCategories = $this->ItemCategoryModel->getAllCategories();
        $Suppliers=$this->SuppliersModel->getIndexData();       

        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Receivings',
            'link' => 'receivings',
            'sources' => $items,
            'Suppliers'=>$Suppliers,
            'ItemCategories'=>$ItemCategories,
            'userinfo' => $user_info,
        );
        return view('receivings', $data);
    }

    public function saveRecItem()
    {
        $validation = \Config\Services::validation();
        $request = \Config\Services::request();
        $validation = $validation->withRequest($request);

        $rules = [
            'SupplierID' => 'required',
            'UserID' => 'required',
            'RAmount' => 'required',
            'RNet' => 'required',
            'RNetwithtax' => 'required',
            'RPaymentType' => 'required',
        ];

        $validation->setRules($rules);
        if($this->request->getMethod() == 'post') {
            $formdata = $this->request->getPost('frmData');
            //var_dump($formdata);
            // receiving table data
            $tableData = $this->request->getPost('tableData');
            //var_dump($tableData);
            // serialized form data
            $serial_detail = $this->request->getPost('groupedSerialData');
            if($formdata){
                parse_str($formdata, $parseData);
                $formdata = [
                    'SupplierID' => $parseData['supplier'],
                    'RType'  => $parseData['recMode'],
                    'UserID'  => $parseData['userId'],
                    'RComment'  =>$parseData['comments'],
                    'RAmount'  => $parseData['ramount'],
                    'RNet'  =>$parseData['subtot'],
                    'RNetwithtax'  => $parseData['tot'],
                    'RPaymentType'  => $parseData['payType'],
                    'RCreatedAt' => $this->now,
                    'RStatus'=>'1',
                ];
            }
            //var_dump($formdata);
            //var_dump($tableData);
            //var_dump($serial_detail);
        }
        
        if($validation->run($formdata)){
            //insert receiving data to receving table
            $last_id = $this->ReceivingModel->insertRecData($formdata);
            if($tableData){                
                if($last_id){                      
                    $i=0;
                    if (!empty($tableData) && is_array($tableData)) {
                        foreach ($tableData as $item) {                    
                            $finalTabledata[] = [                           
                                'RID'=>$last_id,
                                'ItemID' => $item['id'],
                                'RDIsSerialized'=>$item['serialized'],
                                'RDLine'=>$i,
                                'RDQty' => $item['qty'],
                                'RDCostPrice'=>$item['price'],
                                'RDCreatedAt'=>$this->now
                            ];
                            $i++;
                        }

                        //$keyarr=[];
                        for($i = 0; $i < Count($finalTabledata); $i++){
                            // save receving details to receving detail table
                            $last_id= $this->RDetailModel->saveData($finalTabledata[$i]);

                            // get the serialize detail of each record in receiving detail table
                            $serial_status[] = $finalTabledata[$i]['RDIsSerialized']; 
                                
                            // check if there is serialized item in receiving or not  
                            if (in_array('1', $serial_status)) {                           

                                // get data of serialized item  from receving details table
                                $data=$this->RDetailModel->where('RDIsSerialized', 1)->find($last_id);
                                
                                //$s = null;
                                if($data){                                    
                                    //var_dump($serial_detail);
                                    foreach ($serial_detail as $serialitem) {

                                        // Create an empty array for serialized items
                                        $serialitems = array();
                                        //add RDID into array
                                        $serialitems['RDID'] = $data['RDID'];
                                        // Loop through some values and append them to the array with keys
                                        for ($j = 0; $j < Count($serialitem); $j++) {
                                            $serialitems[$serialitem[$j]['Name']] = $serialitem[$j]['Value'];
                                        }
                                        //add created date and status into array
                                        $serialitems['RefCreatedAt'] = $this->now;
                                        $serialitems['RefStatus'] = '1';

                                        $finalInsert = $this->RecevingSerailModel->insertSerailData($serialitems);

                                        if($finalInsert){
                                            echo json_encode(array('status' => true));
                                        }else{
                                            echo json_encode(array("status" => false));
                                        }
                                    }
                                    //$serchIndex = $serialitems.findIndex((element) => element === 'RefQty');
                                }else{
                                    $empty_data['RDID'] = 0;
                                    //array_push($keyarr,$empty_data);
                                }                                 
                            }else{
                                echo "The array does not contain '1'";
                            }
                        }                  
                    }
                }else{	
                    echo json_encode(array('success'=>false));
                }
            }
            echo json_encode(array('success'=>true));
            //var_dump('Success');
        }else{
            echo json_encode(array('success'=>false));
            //var_dump('Validation failed');
        }
        // if($this->request->getMethod() == 'post') {
        //     $formdata = $this->request->getPost('frm_data');
        //     // receiving table data
        //     $tableData = $this->request->getPost('tableData');
        //     // serialized form data
        //     $serial_detail = $this->request->getPost('groupedSerialData');
        //     trace($this->request->getPost('groupedSerialData'));
        //     if($formdata){
        //         parse_str($formdata, $parseData);
        //         $formdata = [
        //             'SupplierID' => $parseData['supplier'],
        //             'RType'  => $parseData['recMode'],
        //             'UserID'  => $parseData['userId'],
        //             'RComment'  =>$parseData['comments'],
        //             'RAmount'  => $parseData['ramount'],
        //             'RNet'  =>$parseData['subtot'],
        //             'RNetwithtax'  => $parseData['tot'],
        //             'RPaymentType'  => $parseData['payType'],
        //             'RCreatedAt' => $this->now,
        //             'RStatus'=>'1',
        //         ];
        //     }
        //     if($validation->run($formdata)){
        //         //if( $frmData || $tableData ){
        //         if($tableData){
        //             //insert receiving data to receving table
        //             $last_id=$this->ReceivingModel->insertRecData($formdata);
        //             //check if receiving table has receving 
        //             if($last_id){                      
        //                 $i=0;
        //                 if (!empty($tableData) && is_array($tableData)) {
        //                     foreach ($tableData as $item) {                    
        //                         $finalTabledata[] = [                           
        //                             'RID'=>$last_id,
        //                             'ItemID' => $item['id'],
        //                             'RDIsSerialized'=>$item['serialized'],
        //                             'RDLine'=>$i,
        //                             'RDQty' => $item['qty'],
        //                             'RDCostPrice'=>$item['price'],
        //                             'RDCreatedAt'=>date('Y-m-d H:i:s')
        //                         ];
        //                         $i++;
        //                     }
                                
        //                     //$keyarr=[];
        //                     for($i = 0; $i < Count($finalTabledata); $i++){                       
        //                         // save receving details to receving detail table
        //                         $last_id= $this->RDetailModel->saveData($finalTabledata[$i]);

        //                         // get the serialize detail of each record in receiving detail table
        //                         $serial_status[] = $finalTabledata[$i]['RDIsSerialized']; 
                                    
        //                         // check if there is serialized item in receiving or not  
        //                         if (in_array('1', $serial_status)) {                           

        //                             // get data of serialized item  from receving details table
        //                             $data=$this->RDetailModel->where('RDIsSerialized', 1)->find($last_id);
                    
        //                             if($data){
        //                                 // if there is serialized record insert those data to keyarr array
        //                                 //return $serial_detail;
        //                                 // foreach ($serial_detail as $item) {                    
        //                                 //     $serialdata[] = [                           
        //                                 //         'RDID'=>$data['RDID'],
        //                                 //         'RefSerialNos' => $item['RefSerialNos'],
        //                                 //         'RefComment'=> $item['RefComment'],
        //                                 //         'RefQty'=> $item['RefQty'],
        //                                 //         'RefPrice' => $item['RefPrice'],
        //                                 //         'RDCreatedAt'=>date('Y-m-d H:i:s')
        //                                 //     ];
        //                                 // }
                                        
        //                                 // for($j = 0; $j < Count($serialdata); $j++){
        //                                 //     $this->model->RecevingSerailModel($data);
        //                                 // }
        //                             }else{
        //                                 $empty_data['RDID'] = 0;
        //                                 //array_push($keyarr,$empty_data);
        //                             }                                 
        //                         }else{
        //                             echo "The array does not contain '1'";
        //                         }
        //                     }
        //                     // print_r($keyarr);

        //                     // for($i = 0; $i < Count($keyarr); $i++){
        //                     //     if(array_key_exists('RDID',$keyarr[$i])){
        //                     //         if($keyarr[$i]['RDID'] == 0){
        //                     //             unset($keyarr[$i]);
        //                     //         }
        //                     //     }  
        //                     // }

        //                     // $keyarr = array_values($keyarr);
        //                     // $RDIDARR = [];

        //                     // for($i = 0; $i < Count($keyarr); $i++){
        //                     //     if(array_key_exists('RDID',$keyarr[$i])){                        
        //                     //         // take serialized record id from receiving detail table
        //                     //         $RDIDARR[] = $keyarr[$i]['RDID'];

        //                     //         // for($i = 0; $i < Count($serial_detail); $i++){

        //                     //         //     print_r($serial_detail[$i]);
        //                     //         // }
        //                     //     }  
        //                     // }

        //                     //for($i = 0; $i < Count($serial_detail); $i++){                                        
        //                         //$array_json = json_encode($serial_detail[$i]);
        //                         //print_r($array_json);                                
        //                     //}                    
        //                 }
        //             }else{	
        //                 echo json_encode(array('success'=>false));
        //             }
                    
        //             var_dump('success');
        //         }else{ //failue
        //             var_dump('ER');
        //             return 'error';
        //         }                
        //         return $this->response->redirect(site_url('/receivings'));
        //     }else{            
        //         var_dump('error');
        //         $user_info = getUserInfo();   
        //         $items = $this->ItemsModel->getItemIndexData();
        //         $ItemCategories = $this->ItemCategoryModel->getAllCategories();
        //         $Suppliers=$this->SuppliersModel->getIndexData();
        //         $errors = $validation->getErrors();
        //         $data = [
        //             'breadcrumbs' => 'true',
        //             'title' => 'Receivings',
        //             'link' => 'receivings',
        //             'sources' => $items,
        //             'Suppliers'=>$Suppliers,
        //             'ItemCategories'=>$ItemCategories,
        //             'userinfo' => $user_info,
        //             'validation' => $errors,
        //         ];
        //         return view('receivings', $data);
        //     }
        // }
    }

    public function singleItemData($id=null)
    {
        $data=$this->ItemsModel->getSingleItemData($id);
       
        if($data){
            echo json_encode(array('data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function delete($id = null)
    {
        $data = [
            'RDeletedAt' => $this->now,
            'RStatus' => '0',
        ];
        // $model->update($id, $data);
        $this->ReceivingModel->deleteitem($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        //return $this->response->redirect(site_url('/banks'));
    }
}

