<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Employee extends Migration
{
    public function up()
    {
        //Create Employee Table
        $this->forge->addField([
            'EmpID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'EmpImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],            
            'EmpName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpDesignation' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpDateofBirth' => [
                'type' => 'Date',
            ],
            'EmpNICNo' => [
                'type' => 'varchar',
                'constraint' => 15,
            ],
            'EmpAddressLine1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpAddressLine2' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpCity' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpProvince' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpCountry' => [
                'type' => 'varchar',
                'constraint' => 25,
            ],
            'EmpContactNo' => [
                'type' => 'varchar',
                'constraint' => 15,
            ],
            'EmpEmail' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpAltContactPerson' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'EmpAltNICNo' => [
                'type' => 'varchar',
                'constraint' => 15,
            ],
            'EmpAltContactNo' => [
                'type' => 'varchar',
                'constraint' => 15,
            ],
            'EmpCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'EmpStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('EmpID');
        $this->forge->createTable('employee');
    }

    public function down()
    {
        //Drop Employee Table
        $this->forge->dropTable('employee');
    }
}
