<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Functionalities extends Migration
{
    public function up()
    {
        //Create Functionalities Table
        $this->forge->addField([
            'FID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'FName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],   
            'FCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'FStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('FID');
        $this->forge->createTable('functionalities');
    }

    public function down()
    {
        //Drop Functionalities Table
        $this->forge->dropTable('functionalities');
    }
}
