<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Tenant extends Migration
{
    public function up()
    {
        //Create Tenant Table
        $this->forge->addField([
            'TID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'TName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TLogo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TBRNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TAddress1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TAddress2' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCity' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TProvince' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCountry' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TOwnerName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TOwnerNIC' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'TCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'TStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('TID');
        $this->forge->createTable('tenant');
    }

    public function down()
    {
        //Drop Tenant Table
        $this->forge->dropTable('tenant');
    }
}
