<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Warehouse extends Migration
{
    public function up()
    {
        //Create Warehouse Table
        $this->forge->addField([
            'WHID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'WHName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'WHSpace' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'WHLocation' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'WHCreaterAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'WHUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'WHDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'WHStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('WHID');
        $this->forge->createTable('warehouse');
    }

    public function down()
    {
        //Drop Warehouse Table
        $this->forge->dropTable('warehouse');
    }
}
