<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Receiving extends Migration
{
    public function up()
    {
         //Create Receiving Table
         $this->forge->addField([
            'RID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'RType' => [
                'type' => 'INT',
                'constraint' => 255,
            ],
            'SupplierID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'UserID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RComment' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'RAmount' => [
                'type' => 'INT',
                'constraint' => 255,
            ],
            'RDiscount' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RNet' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RNetwithtax' => [
                'type' => 'DECIMAL',
               'constraint' => '10,2',
            ],
            'RPaymentType' => [
                'type' => 'INT',
            ],
            'RCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'RStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);
        $this->forge->addPrimaryKey('RID');
        $this->forge->createTable('receiving');
    }
    public function down()
    {
          //Drop receiving Table
          $this->forge->dropTable('receiving');
    }
}
