<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemsCategoryInfomationModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemcategory';
    protected $primaryKey       = 'ICID	';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ICName	', 'ICLink', 'ICParentID', 'ICCreatedAt', 'ICUpdatedAt', 'ICDeletedAt', 'ICStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'BCreatedat';
    protected $updatedField  = 'BUpdatedAt';
    protected $deletedField  = 'BDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

// get all data
function index(){
    $data= $this->db->table('itemcategory')->orderBy('ICID ', 'ASC')->where(["ICStatus" => '1'])->get()->getResultArray();
    return $data;
}
function insertData($data)
{
    return $this->db->table('itemcategory')->insert($data);
}
   
 //get specific data
 function getSpecificData($id){
    return $this->db->table('itemcategory')->where(["ICID" => $id])->get()->getRow();
}

// update data
function updateData($id,$data){
    return $this->db->table('itemcategory')->where(["ICID" => $id])->set($data)->update();
}
// delete delete
function deleteData($id,$data){

    return $this->db
    ->table('itemcategory')
    ->where(["ICID" => $id])
    ->set($data)->update();
}

function getCatCheckData($id){
    return $this->db->table('itemcategory')->where(["ICID" => $id])->get()->getRow();
}

}
