<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Evolve POS System</title>
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
            <link rel="stylesheet" href="https://cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
            <link rel="stylesheet" href="scss/main.css">
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.3/dist/sweetalert2.min.css">
        </head>

        <body class="bg-third">
            <!--- Top-Menu --->
            <div class="clearfix bd-highlight top-menu bg-secondary p-1">
                <div class="float-start">
                    <a href="https://evolve-sl.com/"><img src="./assets/images/logo/logo-removebg-preview.png" alt="main_log"></a>
                </div>
                <?php if($breadcrumbs == 'true'){?>
                    <div class="float-start ms-2">
                        <div class=" ms-auto me-auto">
                            <div class="subtitle-line  ms-auto me-auto ml-1">
                                <div class="d-flex bd-highlight ">
                                    <div class="flex-fill bd-highlight text-primary mt-1">
                                        <small>Index</small> / Registration of <?php echo $title; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }else{}?>
                <div class="float-end">
                    <div class="d-flex flex-row bd-highlight m-1 right-side">
                        <div class="p-1 gap-3 bd-highlight serach mx-2">
                            <a href="#" class=""><img src="./assets/images/icons/search.svg" alt="serach"></a>
                        </div>
                        <div class="p-1 bd-highlight notification position-relative mx-2">
                            <a href="#" class="">
                                <img src="./assets/images/icons/notification-bing.svg" alt="notification">
                                <span class="position-absolute top-0 start-0  badge rounded-circle bg-primary">4</span>
                            </a>
                        </div>
                        <div class="p-1 bd-highlight user position-relative">
                            <a class="top-50 start-50" href="#">
                                <img src="./assets/images/icons/avator1.jpg" class="rounded-circle" alt="user">
                                <div class="rounded-circle bg-primary active-dot"></div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!--- Content --->
            <section class=" bg-secondary m-10 full-height bottom-round">
               
                
                <?php $this->renderSection($link) ?>

            <script src="/node_modules/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
            <script>
                $(document).ready(function() {
                    $('#employees').DataTable( {
                        dom: 'Bfrtip',
                        buttons: [
                            { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                            { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                        ],                        
                        info: false
                    } );
                });
                $.extend( DataTable.ext.classes, {
                    "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
	                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
	                //"sFilter": "dnone",
                });

                //Check All
                function checkAll(o) {
                    var boxes = document.getElementsByClassName("select-checkbox");
                    for (var x = 0; x < boxes.length; x++) {
                        var obj = boxes[x];
                        if (obj.type == "checkbox") {
                        if (obj.name != "check")
                            obj.checked = o.checked;
                        }
                    }
                }                
 
                //update bank
                $('body').on('click', '#bankedit', function () {
                    var bank_id = $(this).attr('data-id');
                    $.ajax({
                        url: 'banks/edit/'+bank_id,
                        type: "GET",
                        dataType: 'json',
                        success: function (res) {
                            $('#bankupdate').modal('show');
                            $('#update_banks #BID').val(res.data.BID); 
                            $('#update_banks #BankName').val(res.data.BankName); 
                            $('#update_banks #BCardType').val(res.data.BCardType);
                            $('#update_banks #BRate').val(res.data.BRate);
                            $('#update_banks #BStartingDate').val(res.data.BStartingDate);
                            $('#update_banks #BEndingDate   ').val(res.data.BEndingDate);
                        },
                            error: function (data) {
                        }
                    });
                });

                //delete bank
                $('body').on('click', '#bankdelete', function () {
                    var bankid = $(this).attr('data-id');
                    $.get('banks/delete/'+bankid, function (data) {
                        $('#viewtable tbody #'+ bankid).remove();
                    })
                });  
            </script>
        </body>
    </html>