<?php $this->extend('layouts\master') ?>

<?php $this->section('sales') ?>

        <!--- Sale Status --->
        <div class="container-fluid mt-3">
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="col-4 ps-0">
                            <!-- <div class="d-flex bd-highlight bg-third text-secondary py-1 Bardcode-scn">
                                <div class="p-2 flex-fill bd-highlight fw-bold">Scan Bardcode</div>
                                <div class="flex-fill bd-highlight csn-btn btn linear-bg"><img class="mt-1" src="./assets/images/icons/scanner1.svg">
                                </div>
                            </div> -->
                        </div>
                        <div class="col-12 pe-0">
                            <div class="d-flex bd-highlight bg-third text-secondary py-1 customer-select ps-1">
                                <div class="pt-2 ps-2 flex-fill bd-highlight fw-bold">Customer : </div>
                                <div class="p-2 flex-fill bd-highlight text-right fw-bold customer-name mt-1">
                                    <input type="text" id="customer_id" name="customer_id">
                                </div>
                                <div class="flex-fill bd-highlight text-right pt-1 pb-0">
                                    <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1 bg-secondary rounded text-center mt-1 p-0 cancel-customer">
                                        <a href="">
                                            <img src="./assets/images/icons/search.svg" alt="serach">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="container">
                            <div class="row">
                              <div class="col-8 ms-auto me-auto bg-third mt-3  find-scan-box">
                                <div class="subtitle-line bg-secondary ms-auto me-auto ml-1 mt-2">
                                    <div class="d-flex bd-highlight ">
                                        <div class="flex-fill bd-highlight">Find/Scan Item</div>
                                        <div class="flex-fill bd-highlight">
                                           <input type="text" id="item_id" name="item_id">
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Sale Type</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example">
                                                    <option value="0" selected>---Select Sale Type---</option>
                                                    <option value="1">Cash</option>
                                                    <option value="2">Credit</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Currency</div>
                                            <div class="flex-fill bd-highlight">
                                                <select class="form-select ms-2 py-0 text-primary fw-bold"
                                                    aria-label="Default select example">
                                                    <option selected>LKR</option>
                                                    <option value="1">AUS</option>
                                                    <option value="2">IDR</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table">
                                <div class="tableFixHead mt-2">
                                    <table class="table rounded align-middle" id="sale_item_data_table" name="sale_item_data_table">
                                        <thead class="text-center text-secondary rounded">
                                            <th class="rounded-start" scope="col">Delete</th>
                                            <th scope="col">Item#</th>
                                            <th scope="col">Item Name</th>
                                            <th scope="col">Price</th>
                                            <th scope="col">Qty</th>
                                            <th scope="col">Disc %</th>
                                            <th scope="col">Total</th>
                                            <th class="rounded-end" scope="col">Edit</th>
                                        </thead>
                                        <tbody class="text-primary fw-bold">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-4">
                    <div class="linear-bg rounded-15 p-2">
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Subtotal</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0" colspan="2">Discount</td>
                                        <td class="py-0">0</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Net Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1 my-2">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Payment Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Amount Due</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">0.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">Amount Deduct</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">
                                            <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1"><i
                                                    class="bi bi-x-square"></i></div>
                                        </td>
                                        <td class=" py-0">Cash</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">
                                            <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1"><i
                                                    class="bi bi-x-square"></i></div>
                                        </td>
                                        <td class="py-0">Cheque</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                    <tr>
                                        <td class="py-0">
                                            <div class="btn-outline-danger text-danger fw-bold h5 text-strock-1"><i
                                                    class="bi bi-x-square"></i></div>
                                        </td>
                                        <td class=" py-0">Loyality Card</td>
                                        <td class="py-0">1310.00</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="container bill-option-btn-set mt-2 py-2">
                        <div class="row">
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/cash-coin.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/credit-card.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0 icon-btn">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary py-2">
                                    <a>
                                        <img src="./assets/images/icons/qr-code-scan.svg" alt="home"
                                            class="white-img mt-1">
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col p-0">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/plus-lg.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Add Payment</div>
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/percent.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">Discount</div>
                                    </a>
                                </div>
                            </div>
                            <div class="col p-0">
                                <div
                                    class="menu-item col text-center rounded linear-bg mx-1 ms-1 p-1 align-self-center text-secondary">
                                    <a>
                                        <img src="./assets/images/icons/forward.svg" alt="home" class="white-img mt-1">
                                        <div class="menu-item-name">End Sale</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Sale Status End --->
        <!--Multiple selling price selection modal: start-->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Multiple selling price selection</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3 col">
                            <label for="" class="col-form-label">Select Selling Price:</label>
                            <div id="multiple_selling_price_list" name="multiple_selling_price_list">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Multiple selling price selection modal: end-->
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
        $(document).ready(function() {
            $('#sale_item_data_table').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        $('#item_id').keypress(function(event){
            var keycode = (event.keyCode ? event.keyCode : event.which);
            var item_id = $("#item_id").val();
            //capture enter key press
            if(keycode == '13'){
                //get data
                $.ajax({
                    url: 'item/get-item-data/'+item_id,
                    type: "GET",
                    dataType: 'json',
                    success: function (res) {
                        //set data
                        var item_id = res.data.item_id;
                        var item_name = res.data.item_name;
                        var item_sale_price = res.data.selling_price;
                        var delete_icon = '<div class="btn-outline-danger text-danger fw-bold h5 text-strock-1"><i class="bi bi-x-square"></i></div>';
                        var qty = '<input type="number" id="qty" name="qty">';
                        var discount = '<select class="form-select ms-2 py-0 text-primary fw-bold" aria-label="Default select example"><option selected>0</option><option value="1">10</option><option value="2">25</option></select>';
                        var total = '<input type="number" id="total" name="total" readonly>';
                        var edit = '<button class="btn linear-bg text-secondary px-2 py-0" type="button"><i class="bi bi-pen-fill"></i></button>';
                        var selected_selling_price = '';
                        var sale_price = '';
                        //check for multiple selling prices
                        if(item_sale_price.length > 1){
                            for(i=0;i<item_sale_price.length;i++){
                                var selectionButton = $('<button class="multipe-selling-price-btn dt-button btn linear-bg text-secondary px-2 py-0"/>').text(item_sale_price[i]);
                                $("#multiple_selling_price_list").append(selectionButton);
                                $("#multiple_selling_price_list").append('<br/><br/>');
                            }
                            $("#submit_modal").modal('toggle'); 
                            $("#submit_modal").modal('show'); 
                            $('.multipe-selling-price-btn').click(function(event){
                                selected_selling_price = $(this).text();
                                localStorage.setItem('selected_selling_price',selected_selling_price);
                                $("#multiple_selling_price_list").empty();
                                $("#submit_modal").modal('hide'); 
                            });
                            sale_price = selected_selling_price;
                        }
                        else{alert('4')
                            sale_price = item_sale_price;
                        }
                        //populate table
                        $("#sale_item_data_table").DataTable().clear();
                        $( ".dataTables_empty").remove();
                        $("#sale_item_data_table").append("<tr><td>" + delete_icon + "</td><td>" + item_id + "</td><td>" + item_name + "</td><td class='sale_price_td'>" + sale_price + "</td><td>" + qty + "</td><td>" + discount + "</td><td>" + total + "</td><td>" + edit + "</td></tr>");
                        // $('#sale_price_td').val(1);
                        // $('.sale_price_td').html(sale_price);
                        populateItemTable();
                    },
                    error: function(xhr, status, error) {
                        var err = eval("(" + xhr.responseText + ")");
                        alert("No item found!");
                        // alert(err.Message);
                    }
                }); 
                $("#item_id").val("");
            }
        });
        function populateItemTable(){
            var selected_selling_price = localStorage.getItem('selected_selling_price');alert(selected_selling_price)
            $('.sale_price_td').html(selected_selling_price);
            localStorage.removeItem('selected_selling_price');
        }
    </script>

<?php $this->endSection() ?>