<?php

namespace App\Controllers;

use App\Models\ItemCategoryModel;
use App\Models\ItemsCategoryDetailsModel;
// use App\Models\ItemsModel;
// use App\Models\UnitsModel;
use App\Models\UserModel;
use App\Controllers\BaseController;

class ItemCategoryController extends BaseController
{
    private $UserModel = null;
    private $ItemCategoryModel = null;
    private $ItemsCategoryDetailsModel = null;
    // private $ItemsModel = null;
    // private $UnitsModel = null;
    private $now = null;

    public function __construct()
    {   
        $this->UserModel = new UserModel();
        $this->ItemCategoryModel = new ItemCategoryModel();
        $this->ItemsCategoryDetailsModel = new ItemsCategoryDetailsModel();
        // $this->ItemsModel = new ItemsModel();
        // $this->UnitsModel = new UnitsModel();
        $this->now = date("Y-m-d H:i:s");

        helper(['url','form']);
    }

    public function index()
    {
        $Categories['ItemCategories'] = $this->ItemCategoryModel->where('delete_flag', '0')->orderBy('ICID', 'ASC')->findAll();
        $ItemCategories = $this->printCategories($Categories);
        $loggedUserID = session()->get('loggedUser');
        $user_info = $this->UserModel->getSingleUserData($loggedUserID);

        $data = array(
            'ItemCategories' => $ItemCategories,
            'userinfo' => $user_info
        );
        return view($data);
    }
    
    // insert data
    public function insert()
    {
        $session = session();
        // if($validation){
        $icid = $this->request->getVar('ICID');
        //Insert Item Category
        if($icid == ''){
            // input's Parent ID
            $ICPID = $this->request->getVar('ICParentID');
            $this->checkLevel($ICPID);
            $data = [
                'ICName' => $this->request->getVar('ICName'),
                'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                'ICParentID'  => $this->request->getVar('ICParentID'),
                'delete_flag' => '0',
                'ICCreatedAt' => $this->now,
            ];
           
            //set trans status
            $transaction_status = false;
            //---begin transaction---
            $this->db->transBegin();
            //---insert sale data---
            $this->ItemCategoryModel->insert($data);
            $lastInsertedCatID = $this->ItemCategoryModel->getInsertID();
          
            $catcheck = $this->ItemCategoryModel->where('ICID', $lastInsertedCatID)->first();
            $parentID = $catcheck['ICParentID'];
            if($parentID == '0'){
                $path = $this->request->getVar('ICName');
            }else{                
                $parentCheck = $this->ItemCategoryModel->where('ICID', $parentID)->first();
                $path = $parentCheck['ICName'];
            }

            if($lastInsertedCatID){
                $catdetailsdata = [
                    'ICID' => $lastInsertedCatID,
                    'ICPath' => $path,
                    'ICLink' => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                    'ICDStatus' => '1',
                ];

                $this->ItemsCategoryDetailsModel->insert($catdetailsdata);
                if ($this->db->transStatus() === FALSE){
                    //---rollback transaction
                    $this->db->transRollback();
                    $transaction_status = false;
                          // Set the success flash message
                    $session->setFlashdata('title', 'Error');
                    $session->setFlashdata('message', 'Error.');
                }
                else{
                    //---commit transaction
                    $this->db->transCommit();
                    $transaction_status = true;
                    $session->setFlashdata('title', 'success');
                    $session->setFlashdata('message', 'Saved.');
                }
            }

        }else{ //update Item Category
            $data = [
                'ICName' => $this->request->getVar('ICName'),
                'ICLink'  => strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                'ICParentID'  => $this->request->getVar('ICParentID'),
                'ICUpdatedAt' => $this->now,
            ];

            $catcheck = $this->ItemCategoryModel->where('ICID', $icid)->first();
            $catdetailscheck = $this->ItemsCategoryDetailsModel->where('ICID', $icid)->first();
            $updateparentedid = $this->request->getVar('ICParentID');
            if($updateparentedid == $catcheck['ICParentID']){                
                $catdetailsdata = [
                    'ICLink'=> strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                ];
                
            }else{
                $catcheck = $this->ItemCategoryModel->where('ICID', $updateparentedid)->first();
                $updatepath = $catcheck['ICName'];
                $catdetailsdata = [
                    'ICPath'=> $updatepath,
                    'ICLink'=> strtolower(str_replace(array( '\'', ' ',), '', $this->request->getVar('ICName'))),
                ];
                var_dump($catdetailsdata);
            }
            
            $this->ItemCategoryModel->updateItemCatgories($icid, $data);
            $this->ItemsCategoryDetailsModel->updateItemCatgoryDetails($catdetailscheck['ICDID'], $catdetailsdata);
        }
        return $this->response->redirect(site_url('/items'));
    }

    //get single data
    public function singleData($id = null) 
    {
        $data=$this->ItemCategoryModel->getSingleICData($id);

        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    // delete
    public function delete($id = null)
    {
        $data = [
            'ICDeletedAt' => $this->now,
            'delete_flag' => '1',
        ];
        $this->ItemCategoryModel->deleteCategories($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
    }

    public function printCategories($categories, $parent_id = 0)
    {
        foreach ($categories as $category) {
            if ($category['parent_id'] == $parent_id) {
                echo str_repeat ($category['name'] . '<br>');
                printCategories($categories, $category['id']);
            }
        }
    }    
}
