<?php

namespace App\Controllers;
use App\Models\UserModel;
use App\Models\TenantModel;
use App\Models\CommonModel;

use App\Controllers\BaseController;

class TenantController extends BaseController
{
    //construct function
    public function __construct()
    {
        $this->tenants = new TenantModel();
        $this->common = new CommonModel();  
        $this->db = \Config\Database::connect();      
        helper(['url','form','app']);
    }
    //get all data
    public function index()
    {
        $user_info = getUserInfo();
        $records['Tenant'] = $this->tenants->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'Tenant',
            'link' => 'tenant',
            'sources' => $records,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
        );
        return view('tenant', $data);
    }
    public function register() 
    {
        $user_info = getUserInfo();
        $validation = $this->validate([
            'TName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter name',
                ],
            ],
            'TBRNo' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter BR number',
                ],
            ],
            'TCity' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter  a city',
                ],
            ],
            'TProvince' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter a province',
                ],
            ],
            'TCountry' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter a country',
                ],
            ],
            'TOwnerName' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter owner name',
                ],
            ],
            'TOwnerNIC' => [
                'rules'=>[
                    'rules'=>'required',
                    'is_unique[tenant.TOwnerNIC,TID,{TID}]',
                    'regex_match[/^[0-9]{9}[vVxX]$/]'
                ],
                'errors'=>[
                    'required'=>'Please enter NIC numbber',
                    'regex_match' => 'Not a valid NIC number.',
                    'is_unique'=>'This NIC already exists!',
                ],
            ],
        ]);
        $tID = $this->request->getVar('TID');
        $session = session();
        if($validation){
            if($tID == ''){  //insert tenant details
        $data = [
            'TName' => $this->request->getVar('TName'),
            'TLogo'=>$this->request->getVar('TLogo'),
            'TBRNo' => $this->request->getVar('TBRNo'),
            'TAddress1' => $this->request->getVar('TAddress1'),
            'TAddress2' =>$this->request->getVar('TAddress2'), 
            'TCity' => $this->request->getVar('TCity'),
            'TProvince' => $this->request->getVar('TProvince'),
            'TCountry' =>$this->request->getVar('TCountry'), 
            'TOwnerName' => $this->request->getVar('TOwnerName'),
            'TOwnerNIC' =>$this->request->getVar('TOwnerNIC'), 
            'TCreatedAt' => date('Y-m-d H:i:s'),   
            'TCreatedBy' =>  $user_info->UserID,
            'delete_flag'=>'0' ,       
        ];
        if(!empty($_FILES['TLogo']['name'])){             
            $imageFile = $this->request->getFile('TLogo');
            $imageFile->move('../public/uploads/tenantImg');
            $imgDetail =$_FILES['TLogo'];
            $data['TLogo']= $imgDetail ['name'];        
        }
        //set trans status
        $transaction_status = false;
        //---begin transaction---
        $this->db->transBegin();
        $this->tenants->insertTenantData($data);
        if ($this->db->transStatus() === FALSE){
            //---rollback transaction
            $this->db->transRollback();
            $transaction_status = false;
               // Set the success flash message
            $session->setFlashdata('title', 'Error');
            $session->setFlashdata('icon', 'warning');
            $session->setFlashdata('message', 'Something Went wrong.');  
        }
        else{
            //---commit transaction
            $this->db->transCommit();
            $transaction_status = true;
           // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('icon', 'success');
            $session->setFlashdata('message', 'Tenant  details saved successfully.'); 
        }           
           }
        else{
            $data = [
                'TName' => $this->request->getVar('TName'),
                'TLogo'=>$this->request->getVar('TLogo'),
                'TBRNo' => $this->request->getVar('TBRNo'),
                'TAddress1' => $this->request->getVar('TAddress1'),
                'TAddress2' =>$this->request->getVar('TAddress2'), 
                'TCity' => $this->request->getVar('TCity'),
                'TProvince' => $this->request->getVar('TProvince'),
                'TCountry' =>$this->request->getVar('TCountry'), 
                'TOwnerName' => $this->request->getVar('TOwnerName'),
                'TOwnerNIC' =>$this->request->getVar('TOwnerNIC'), 
                'TUpdatedAt' => date('Y-m-d H:i:s'),
                'TUpdatedBy' =>  $user_info->UserID,
                'delete_flag'=>'0' ,       
                
            ];
            if(!empty($_FILES['TLogo']['name'])){             
                $imageFile = $this->request->getFile('TLogo');
                $imageFile->move('../public/uploads/tenantImg');
                $imgDetail =$_FILES['TLogo'];
                $data['TLogo']= $imgDetail ['name'];        
            }
            $this->tenants->updateTenantData($tID, $data);  
             // Set the success flash message
          $session->setFlashdata('title', 'Saved');
          $session->setFlashdata('message', 'Tenant details updated successfully.');               
           }
            $this->response->redirect(site_url('/tenant'));
      }
        else{
                $user_info = getUserInfo();
                $records['Tenant'] = $this->tenants->index();
                $has_errors = 'true';
                $data = array(
                    'breadcrumbs' => 'true',
                    'title' => 'Tenant',
                    'link' => 'tenant',
                    'sources' => $records,
                    'userinfo' => $user_info,
                    'has_errors' => $has_errors,
                    'validation'=>$this->validator,
                );
                return view('tenant', $data);
        }
    }
      //get single data
    public function singleData($id = null) 
    { 
        $data=$this->tenants->getSingleTenantData($id);
        if($data){                
            echo json_encode(array("status" => true , 'data' => $data));
        }else{            
            echo json_encode(array("status" => false));
        }
    }  

    // delete tenant
    public function delete($id = null)
    {
        $user_info = getUserInfo();
        $has_terminals_info = $this->common->checkForeignKeyConstraints("terminals","tenant_id",$id,"delete_flag",0);
        $now = date("Y-m-d H:i:s");
         //define message
         $msg_prefix = 'This tenant has ';
         $msg_terminals_info = 'terminals information';
         $msg = '';
         if($has_terminals_info ){
             $msg = $msg_prefix.$msg_terminals_info;
         }
        
        $data = [
            'TDeletedAt' => $now,
            'delete_flag' => '1',
            'TDeletedBy' =>  $user_info->UserID
        ];
        if($has_terminals_info){
                return $this->response->setJSON([
                    'error' => true,
                    'message' =>  $msg 
                ]);
            }
            else{
                $this->tenants->deleteTenant($id, $data);
                return $this->response->setJSON([
                    'error' => false,
                    'message' => 'Successfully deleted!'
                ]);
            }
    }
   // Payment Type disable
   public function disabletenant($id = null)
   {
       $data = [
           'current_status' => '2'
       ];
       if($this->tenants->statusupdate($id, $data)):                
           echo json_encode(array('status'=>true));
       endif;
   }
   // Payment Type enable
   public function enabletenant($id = null)
   {
       $data = [
           'current_status' => '1'
       ];
       if($this->tenants->statusupdate($id, $data)):                
           echo json_encode(array('status'=>true));
       endif;
   }
    
}
