<?php   
namespace App\Models;

use CodeIgniter\Model;

class CustomerContactInformationModel extends Model{
    protected $DBGroup = 'default';
    protected $table = 'customers';
    protected $primaryKey = 'CusId';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = true;
    protected $allowedFields = ['customer_id', 'address','phone_number','email','is_default','created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    
    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert data
    function insertData($data)
	{
        return $this->db->table('customer_contact_information')->insert($data);
	}
    //get specific data
    function getSpecificData($id){
        return $this->db->table('customer_contact_information')->where(["id" => $id])->get()->getRow();
    }
    // get all data
    function index(){
        $data= $this->db->table('customer_contact_information')->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateData($id,$data){
        return $this->db->table('customer_contact_information')->where(["id" => $id])->set($data)->update();
    }
    // delete delete
    function deleteData($id,$data){
        return $this->db->table('customer_contact_information')->where(["id" => $id])->set($data)->update();
    }
    //get specific customer default contact data
    function getSpecificCustomerDefaultContactInfo($customer_id){
        return $this->db->table('customer_contact_information')->where(["customer_id" => $customer_id])->where(["is_default" => 1])->where('delete_flag', 0)->get()->getResultArray();
    }
    //change customer contact info default status
    function changeCustomerContactInfoDefaultStatus($id,$customer_id,$data){
        $has_contact_data = $this->getSpecificCustomerDefaultContactInfo($customer_id);
        if(count($has_contact_data) > 1){
            return $this->db->table('customer_contact_information')->where(["id" => $id])->set($data)->update();
        }
        else{
            $this->db->table('customer_contact_information')->where(["id" => $id])->set($data)->update();
            return false;
        }
    }
    // get specific customer contact data
    function getSpecificCustomerContactInfo($customer_id){
        $data= $this->db->table('customer_contact_information')->where(["customer_id" => $customer_id])->where('delete_flag', 0)->orderBy('id ', 'ASC')->get()->getResultArray();
        return $data;
    }
    // update data
    function updateDefaultData($id,$data){
        return $this->db->table('customer_contact_information')->where(["id" => $id])->set($data)->update();
    }
    //search customer by phone number
    function searchCustomerByPhoneNumber($customer_phone_number){
        $data= $this->db->table('customer_contact_information')->where(["phone_number" => $customer_phone_number])->where('delete_flag', 0)->where('current_status', 1)->orderBy('id ', 'ASC')->get()->getRow();
        return $data;
    }
    //check customer count
    function checkCustomerCount($customer_id){
        $data= $this->db->table('customer_contact_information')->where(["customer_id" => $customer_id, 'is_default' => '1'])->countAllResults();
        return $data;
    }
}