<?php

namespace App\Models;

use CodeIgniter\Model;

class UserPermissionModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'rulebook';
    protected $primaryKey       = 'RBID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RBID', 'RoleID', 'UserID', 'FID', 'RBCreatedAt', 'RBUpdatedAt', 'RBDeletedAt', 'delete_flag','RBCreatedBy','RBUpdatedBy', 'RBDeletedBy','Fnames'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RBCreatedAt';
    protected $updatedField  = 'RBUpdatedAt';
    protected $deletedField  = 'RBDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get user role data
    public function getUPIndexData()
    {
        $data= $this->db
            ->table('rulebook')
            ->where('delete_flag', '0')
            // ->join('userpermissiondetail', 'userpermissiondetail.ruleBID = rulebook.RBID')
            // ->join('functionalities', 'functionalities.FID = userpermissiondetail.functionalityID')
            // // ->groupBy('RBID')
            ->get()
            ->getResultArray();
        return $data;
    }
    
    public function getFunData()
    {
        $data= $this->db
            ->table('rulebook')
            ->where('delete_flag', '0')
            // ->where('current_status', '1')
            ->orderBy('RBID', 'ASC')
            ->select('FID')
            ->get()
            ->getResultArray();
        return $data;
    }
    public function insertuPermissionData($data)
    {        
        return $this->db
            ->table('rulebook')
            ->insert($data);
    }
    
    // get signle employee data
    function getSingleUserPermissionData($id)
    {
        return $this->db
             ->table('rulebook')
            //  ->where(["RBID" => $id])
             ->where('rulebook.RBID',$id)
             ->join('userrole', 'userrole.URoleID = rulebook.RoleID','left')
             ->join('user', 'user.UserID = rulebook.UserID','left')
             ->get()
             ->getRow();
    }


    // update user role data
    function updatePermission($id,$data)
    {
        return $this->db
            ->table('rulebook')
            ->where('rulebook.RBID',$id)
            ->set($data)
            ->update();
    }

    
    // update Fname datsa
    function updateFname($id,$data)
    {
//         $query = $this->db
//                  ->table('rulebook')
//                  ->select('rulebook.FID')
//                  ->where('delete_flag', '0')
//                  ->get();

//         $result = $query->getResult();
//           $values = [];
//     foreach ($result as $row) {
//         // echo '<pre>';
       
//         $commaSeparatedValues = $row->FID;
//         $individualValues = explode(',', $commaSeparatedValues);
       
//         $values = array_merge($values, $individualValues);
//         return $values;
        
//   echo '<pre>';
//   print_r($values);
    
//     }
//     die();
        return $this->db
            ->table('rulebook')
            ->where('rulebook.FID',$id)
            ->set('Fnames', $data)
            ->update();
    }
   
 
      

       
    
    
    // delete user role data
    function deleteUserPer($id,$data)
    {
        // die();
        return $this->db
            ->table('rulebook')
            ->where('rulebook.RBID',$id)
            ->set($data)
            ->update();
    }
    //get permission data for user
    function getPermissionDataForUser($user){
        $user_permission_data = $this->db->table('rulebook')->where('UserID', $user)->select('Fnames')->get()->getRow();
        if($user_permission_data){
            $Fnames = $user_permission_data->Fnames;
        }
        else{
            $Fnames = "";
        }
        return $Fnames;
    }
}

